package cn.langpy.disroute.core;

import com.alibaba.fastjson.JSONObject;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Route {

    public static boolean isInit() {
        return RouteContext.instanceMap.size() > 0;
    }

    public static void init(String packagePath) {
        RouteContext.init(packagePath);
    }

    public static void init() {
        RouteContext.init();
    }

    public static void close() {
        RouteContext.close();
    }


    private String context = "context";
    private List<String> contexts;
    private Object param;
    private Boolean async = false;

    public Route() {
    }

    public Route(String context, Object param) {
        this.context = context;
        this.param = param;
    }


    public Route context(String context) {
        this.context = context;
        return this;
    }

    public Route contexts(List<String> contexts) {
        this.contexts = contexts;
        return this;
    }

    public Route async(boolean async) {
        this.async = async;
        return this;
    }

    public Route param(Object param) {
        this.param = param;
        return this;
    }

    public Route param(JSONObject param) {
        this.param = param;
        return this;
    }

    public Route param(Map param) {
        this.param = param;
        return this;
    }

    public static Route build() {
        return new Route();
    }

    public <T> T dispatch() {
        if (this.contexts==null) {
            if (this.async) {
                return RouteContext.dispatchAsync(context, param);
            }else {
                return RouteContext.dispatch(context, param);
            }
        }else {
            List results = new ArrayList<>();
            for (String context : this.contexts) {
                if (this.async) {
                     RouteContext.dispatchAsync(context, param);
                }else {
                    Object result = RouteContext.dispatch(context, param);
                    results.add(result);
                }
            }
            return (T)results;
        }

    }

    public static <T> T dispatch(Object arg) {
        String context = "context";
        return dispatch(context, arg);
    }

    public static <T> T dispatch(JSONObject arg) {
        String context = "context";
        return dispatch(context, arg);
    }

    public static <T> T dispatch(Map arg) {
        String context = "context";
        return dispatch(context, arg);
    }

    public static <T> T dispatch(String context, Object param) {
        return RouteContext.dispatch(context, param);
    }

    public static <T> T dispatch(String context, JSONObject param) {
        return RouteContext.dispatch(context, param);
    }

    public static <T> T dispatch(String context, Map param) {
        return RouteContext.dispatch(context, param);
    }

}
