package cn.langpy.disroute.core;

import com.alibaba.fastjson.JSONObject;

import java.util.Map;

public class Route {

    public static boolean isInit() {
        return RouteContext.instanceMap.size() > 0;
    }

    public static void init(String packagePath) {
        RouteContext.init(packagePath);
    }

    public static void init() {
        RouteContext.init();
    }

    private String context = "context";
    private Object param;

    public Route() {
    }

    public Route(String context, Object param) {
        this.context = context;
        this.param = param;
    }


    public Route context(String context) {
        this.context = context;
        return this;
    }

    public Route param(Object param) {
        this.param = param;
        return this;
    }

    public Route param(JSONObject param) {
        this.param = param;
        return this;
    }

    public Route param(Map param) {
        this.param = param;
        return this;
    }

    public static Route build() {
        return new Route();
    }

    public <T> T dispatch() {
        return dispatch(context, param);
    }

    public static <T> T dispatch(Object arg) {
        String context = "context";
        return dispatch(context, arg);
    }

    public static <T> T dispatch(JSONObject arg) {
        String context = "context";
        return dispatch(context, arg);
    }

    public static <T> T dispatch(Map arg) {
        String context = "context";
        return dispatch(context, arg);
    }

    public static <T> T dispatch(String context, Object param) {
        return RouteContext.dispatch(context, param);
    }

    public static <T> T dispatch(String context, JSONObject param) {
        return RouteContext.dispatch(context, param);
    }

    public static <T> T dispatch(String context, Map param) {
        return RouteContext.dispatch(context, param);
    }

}
