package cn.langpy.disroute.core;

import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

import java.util.logging.Logger;

@Component
public class ContextInit implements ApplicationRunner {
    @Value("${disroute.scan:com}")
    private String disrouteScan;
    public static Logger log = Logger.getLogger(ContextInit.class.toString());

    @Override
    public void run(ApplicationArguments args) throws Exception {
        log.info("init disroute---start");
        if (disrouteScan.equals("com")) {
            Route.init();
//            throw new InvalidRoutePathException("can not find disroute.scan,please define it in application.yml");
        } else {
            Route.init(disrouteScan);
        }
        log.info("init disroute---end");
    }

}
