/*
 * Decompiled with CFR 0.152.
 */
package com.lamp.light.netty;

import com.lamp.light.Callback;
import com.lamp.light.handler.AsynReturn;
import com.lamp.light.handler.DefaultCall;
import com.lamp.light.response.Response;
import com.lamp.light.response.ReturnMode;
import com.lamp.ligth.model.ModelManage;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.DecoderResultProvider;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;

public class NettyClient {
    private Map<ChannelId, AsynReturn> channelIdToAsynReturn = new ConcurrentHashMap<ChannelId, AsynReturn>();
    private EventLoopGroup workerGroup = new NioEventLoopGroup();
    private Bootstrap b = new Bootstrap();
    private Executor executor;

    public NettyClient(Executor executor) {
        this.executor = executor;
        this.init();
    }

    private void init() {
        this.b.group(this.workerGroup);
        this.b.channel(NioSocketChannel.class);
        this.b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000);
        this.b.option(ChannelOption.TCP_NODELAY, (Object)true);
        this.b.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        this.b.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new LightIdleStateHandler()});
                ch.pipeline().addLast(new ChannelHandler[]{new HttpResponseDecoder()});
                ch.pipeline().addLast(new ChannelHandler[]{new HttpRequestEncoder()});
                ch.pipeline().addLast(new ChannelHandler[]{new HttpClientHandler()});
            }
        });
    }

    public Channel getChannle(InetSocketAddress inetSocketAddress) throws InterruptedException {
        return this.b.connect((SocketAddress)inetSocketAddress).sync().channel();
    }

    public void write(final AsynReturn asynReturn, InetSocketAddress inetSocketAddress) {
        this.b.connect((SocketAddress)inetSocketAddress).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    NettyClient.this.channelIdToAsynReturn.put(future.channel().id(), asynReturn);
                    future.channel().writeAndFlush((Object)asynReturn.getFullHttpRequest());
                } else {
                    NettyClient.this.error(asynReturn, future.cause());
                }
            }
        });
    }

    public void error(AsynReturn asynReturn, Throwable throwable) {
        if (asynReturn.getReturnMode().equals((Object)ReturnMode.SYNS)) {
            try {
                Object object = ModelManage.getInstance().getModel(asynReturn.getHandleMethod().getRequestInfo().getReturnClazz(), throwable, null, null);
                if (Objects.nonNull(object)) {
                    asynReturn.setObject(object);
                    return;
                }
                asynReturn.setObject(throwable);
                return;
            }
            catch (Exception e) {
                asynReturn.setObject(e);
                return;
            }
        }
        if (asynReturn.getReturnMode().equals((Object)ReturnMode.CALL)) {
            DefaultCall call = (DefaultCall)asynReturn.getCall();
            call.setThrowable(throwable);
            if (Objects.isNull(call.getCallback())) {
                Callback callback = call.getCallback();
                callback.onFailure(call, asynReturn.getArgs(), throwable);
            } else {
                asynReturn.setObject(call);
            }
        }
    }

    class LightIdleStateHandler
    extends ChannelDuplexHandler {
        private IdleStateHandler idleStateHandler;

        LightIdleStateHandler() {
        }

        private IdleStateHandler getIdleStateHandler(ChannelHandlerContext ctx) throws Exception {
            if (Objects.isNull(this.idleStateHandler)) {
                AsynReturn asynReturn = (AsynReturn)NettyClient.this.channelIdToAsynReturn.get(ctx.pipeline().channel().id());
                this.idleStateHandler = new IdleStateHandler(asynReturn.getRequestTimes().intValue(), -1, -1);
                this.idleStateHandler.handlerAdded(ctx);
            }
            return this.idleStateHandler;
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        }

        public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        }

        public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.getIdleStateHandler(ctx).channelActive(ctx);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.getIdleStateHandler(ctx).channelInactive(ctx);
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            this.getIdleStateHandler(ctx).channelRead(ctx, msg);
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            this.getIdleStateHandler(ctx).channelReadComplete(ctx);
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            this.getIdleStateHandler(ctx).write(ctx, msg, promise);
        }
    }

    class HttpClientHandler
    extends ChannelInboundHandlerAdapter {
        private DefaultHttpResponse defaultHttpResponse;
        private ByteBuf connect;
        private AsynReturn asynReturn;
        private Throwable throwable;

        HttpClientHandler() {
        }

        public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
            this.asynReturn = (AsynReturn)NettyClient.this.channelIdToAsynReturn.remove(ctx.pipeline().channel().id());
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            DecoderResultProvider decoderResultProvider;
            DecoderResult decoderResult;
            if (msg instanceof DecoderResultProvider && Objects.nonNull(decoderResult = (decoderResultProvider = (DecoderResultProvider)msg).decoderResult()) && !decoderResult.isSuccess()) {
                this.throwable = decoderResult.cause();
            }
            if (msg instanceof DefaultHttpResponse) {
                this.defaultHttpResponse = (DefaultHttpResponse)msg;
                HttpHeaders headers = this.defaultHttpResponse.headers();
                Integer contentLength = headers.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                ByteBuf byteBuf = this.connect = Objects.isNull(contentLength) ? Unpooled.buffer((int)8192) : Unpooled.buffer((int)contentLength);
            }
            if (msg instanceof LastHttpContent) {
                LastHttpContent lastHttpContent = (LastHttpContent)msg;
                this.connect.writeBytes(lastHttpContent.content());
                ctx.close();
                this.returnHandle(ctx);
            }
            if (msg instanceof HttpContent) {
                HttpContent content = (HttpContent)msg;
                this.connect.writeBytes(content.content());
            }
        }

        private void returnHandle(ChannelHandlerContext ctx) {
            this.asynReturn = (AsynReturn)NettyClient.this.channelIdToAsynReturn.remove(ctx.pipeline().channel().id());
            if (this.asynReturn.getReturnMode().equals((Object)ReturnMode.SYNS)) {
                if (Objects.nonNull(this.throwable) || !Objects.equals(this.defaultHttpResponse.status(), HttpResponseStatus.OK)) {
                    try {
                        Object object = ModelManage.getInstance().getModel(this.asynReturn.getHandleMethod().getRequestInfo().getReturnClazz(), this.throwable, this.defaultHttpResponse, this.connect);
                        if (Objects.nonNull(object)) {
                            this.asynReturn.setObject(object);
                            return;
                        }
                        this.asynReturn.setObject(this.throwable);
                        return;
                    }
                    catch (Exception e) {
                        this.asynReturn.setObject(e);
                        return;
                    }
                }
                Object object = this.asynReturn.getSerialize().deserialization(this.asynReturn.getHandleMethod().getRequestInfo().getReturnClazz(), this.connect.array());
                this.asynReturn.setObject(object);
                return;
            }
            if (this.asynReturn.getReturnMode().equals((Object)ReturnMode.CALL)) {
                final DefaultCall call = (DefaultCall)this.asynReturn.getCall();
                Response response = new Response((HttpResponse)this.defaultHttpResponse);
                call.setResponse(response);
                call.setThrowable(this.throwable);
                if (Objects.isNull(call.getCallback())) {
                    final Callback callback = call.getCallback();
                    NettyClient.this.executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (Objects.isNull(HttpClientHandler.this.throwable)) {
                                Object object = HttpClientHandler.this.asynReturn.getSerialize().deserialization(HttpClientHandler.this.asynReturn.getClass(), HttpClientHandler.this.connect.array());
                                callback.onResponse(call, HttpClientHandler.this.asynReturn.getArgs(), object);
                            } else {
                                callback.onFailure(call, HttpClientHandler.this.asynReturn.getArgs(), HttpClientHandler.this.throwable);
                            }
                        }
                    });
                } else {
                    this.asynReturn.setObject(call);
                }
            }
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (IdleState.READER_IDLE.equals(evt)) {
                AsynReturn asynReturn = (AsynReturn)NettyClient.this.channelIdToAsynReturn.get(ctx.pipeline().channel().id());
                NettyClient.this.error(asynReturn, new RuntimeException("request timeout"));
            }
            ctx.close();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        }
    }
}

