/*
 * Decompiled with CFR 0.152.
 */
package com.lamp.light.handler;

import com.lamp.light.Call;
import com.lamp.light.Interceptor;
import com.lamp.light.handler.AnnotationAnalysis;
import com.lamp.light.handler.AsynReturn;
import com.lamp.light.handler.Coordinate;
import com.lamp.light.handler.CoordinateHandler;
import com.lamp.light.handler.DefaultCall;
import com.lamp.light.handler.RequestInfo;
import com.lamp.light.handler.TypeToString;
import com.lamp.light.netty.NettyClient;
import com.lamp.light.response.ReturnMode;
import com.lamp.light.serialize.Serialize;
import com.lamp.light.util.BaseUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringEncoder;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class HandleProxy
implements InvocationHandler {
    private AnnotationAnalysis annotationAnalysis = new AnnotationAnalysis();
    private Map<Method, HandleMethod> handleMethodMap = new ConcurrentHashMap<Method, HandleMethod>();
    private NettyClient nettyClient;
    private InetSocketAddress inetSocketAddress;
    private String socketAddress;
    private List<Interceptor> interceptorList = new ArrayList<Interceptor>();
    private RequestInfo requestInfo;
    private Serialize serialize;
    private Object success;
    private Object fail;

    public HandleProxy(NettyClient nettyClient, String path, Class<?> proxy, InetSocketAddress inetSocketAddress, List<Interceptor> interceptorList, Serialize serialize, Object success, Object fail) throws Exception {
        this.nettyClient = nettyClient;
        if (Objects.isNull(success) || Objects.isNull(fail)) {
            // empty if block
        }
        this.requestInfo = this.annotationAnalysis.analysis(proxy);
        this.requestInfo.setUrl(BaseUtils.setSlash(path) + BaseUtils.setSlash(this.requestInfo.getUrl()));
        this.interceptorList = interceptorList;
        this.serialize = serialize;
        this.inetSocketAddress = inetSocketAddress;
        this.success = success;
        this.fail = fail;
        this.socketAddress = inetSocketAddress.toString();
        this.socketAddress = this.socketAddress.substring(1, this.socketAddress.length());
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke((Object)this, args);
        }
        HandleMethod handleMethod = this.handleMethodMap.get(method);
        if (Objects.isNull(handleMethod)) {
            handleMethod = new HandleMethod();
            handleMethod.requestInfo = this.annotationAnalysis.analysis(method, this.requestInfo);
            if (Objects.nonNull(this.success)) {
                handleMethod.success = this.success;
                handleMethod.fail = this.fail;
                handleMethod.returnMode = ReturnMode.ASYSN;
            } else {
                handleMethod.returnMode = handleMethod.requestInfo.getReturnMode();
            }
            this.handleMethodMap.put(method, handleMethod);
        }
        RequestInfo requestInfo = handleMethod.requestInfo;
        if (Objects.nonNull(this.interceptorList)) {
            for (Interceptor interceptor : this.interceptorList) {
                args = interceptor.handlerBefore(proxy, method, requestInfo, args);
            }
        }
        HttpRequest defaultFullHttpRequest = this.getHttpRequest(args, handleMethod);
        if (Objects.nonNull(this.interceptorList)) {
            for (Interceptor interceptor : this.interceptorList) {
                defaultFullHttpRequest = interceptor.handlerRequest(requestInfo, defaultFullHttpRequest);
            }
        }
        AsynReturn asynReturn = new AsynReturn();
        asynReturn.setReturnMode(handleMethod.returnMode);
        asynReturn.setFullHttpRequest(defaultFullHttpRequest);
        asynReturn.setHandleMethod(handleMethod);
        asynReturn.setSerialize(this.serialize);
        this.nettyClient.write(asynReturn, this.inetSocketAddress);
        Call<Object> object = null;
        if (handleMethod.returnMode == ReturnMode.SYNS) {
            object = asynReturn.getObject();
        } else if (handleMethod.returnMode == ReturnMode.CALL) {
            asynReturn.setCall(new DefaultCall<Object>(asynReturn, this.nettyClient, this.inetSocketAddress));
            object = asynReturn.getCall();
        }
        return object;
    }

    public HttpRequest getHttpRequest(Object[] args, HandleMethod handleMethod) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, HttpPostRequestEncoder.ErrorDataEncoderException {
        CoordinateHandler.CoordinateHandlerWrapper coordinateHandlerWrapper = CoordinateHandler.getCoordinateHandlerWrapper();
        RequestInfo requestInfo = handleMethod.requestInfo;
        if (Objects.nonNull(requestInfo.getPathList())) {
            coordinateHandlerWrapper.pathCoordinateHandler.setObject(requestInfo.getUrl());
            this.coordinateHandler(args, requestInfo.getPathList(), coordinateHandlerWrapper.pathCoordinateHandler);
        }
        QueryStringEncoder queryStringEncoder = new QueryStringEncoder(requestInfo.getUrl());
        if (Objects.nonNull(requestInfo.getQueryList())) {
            coordinateHandlerWrapper.queryCoordinateHandler.setObject(queryStringEncoder);
            this.coordinateHandler(args, requestInfo.getQueryList(), coordinateHandlerWrapper.queryCoordinateHandler);
        }
        DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
        Set<Map.Entry<String, String>> it = requestInfo.getHeader().entrySet();
        for (Map.Entry<String, String> e : it) {
            httpHeaders.add(e.getKey(), (Object)e.getValue());
        }
        if (Objects.nonNull(requestInfo.getHeaderList())) {
            coordinateHandlerWrapper.headerCoordinateHandler.setObject(httpHeaders);
            this.coordinateHandler(args, requestInfo.getHeaderList(), coordinateHandlerWrapper.headerCoordinateHandler);
        }
        if (Objects.nonNull(requestInfo.getCookieList())) {
            this.coordinateHandler(args, requestInfo.getCookieList(), coordinateHandlerWrapper.headerCoordinateHandler);
        }
        ByteBuf buffer = Unpooled.EMPTY_BUFFER;
        if (Objects.equals(HttpMethod.POST, handleMethod.requestInfo.getHttpMethod()) && requestInfo.getIsBody().booleanValue()) {
            byte[] bytes = this.serialize.serialize(args[requestInfo.getBodyIndex()]);
            buffer = Unpooled.directBuffer((int)bytes.length).writeBytes(bytes);
            httpHeaders.set("Content-Type", (Object)"application/json");
            httpHeaders.set("Content-Length", (Object)bytes.length);
        }
        httpHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)this.socketAddress);
        ClientCookieEncoder clientCookieEncoder = ClientCookieEncoder.STRICT;
        DefaultFullHttpRequest defaultFullHttpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, requestInfo.getHttpMethod(), queryStringEncoder.toString(), buffer, (HttpHeaders)httpHeaders, (HttpHeaders)httpHeaders);
        if (Objects.nonNull(requestInfo.getFieldList())) {
            HttpPostRequestEncoder httpPostRequestEncoder = new HttpPostRequestEncoder((HttpRequest)defaultFullHttpRequest, false);
            coordinateHandlerWrapper.fieldCoordinateHandler.setObject(httpPostRequestEncoder);
            this.coordinateHandler(args, requestInfo.getFieldList(), coordinateHandlerWrapper.fieldCoordinateHandler);
        }
        return defaultFullHttpRequest;
    }

    private void coordinateHandler(Object[] args, List<Coordinate> coordinateList, CoordinateHandler coordinateHandler) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        for (Coordinate coordinate : coordinateList) {
            Object object = args[coordinate.getIndex()];
            if (Objects.equals((Object)coordinate.getType(), (Object)Coordinate.ParametersType.BASIC) || Objects.equals((Object)coordinate.getType(), (Object)Coordinate.ParametersType.PACKING)) {
                coordinateHandler.handler(coordinate.getKey(), object.toString());
                continue;
            }
            if (Objects.equals((Object)coordinate.getType(), (Object)Coordinate.ParametersType.STRING)) {
                coordinateHandler.handler(coordinate.getKey(), (String)object);
                continue;
            }
            if (Objects.equals((Object)coordinate.getType(), (Object)Coordinate.ParametersType.MAP)) {
                Map map = (Map)object;
                if (Objects.isNull(coordinate.getKey())) {
                    for (Map.Entry e : map.entrySet()) {
                        coordinateHandler.handler((String)e.getKey(), TypeToString.ObjectToString(e.getValue()));
                    }
                    continue;
                }
                coordinateHandler.handler(coordinate.getKey(), TypeToString.ObjectToString(map.get(coordinate.getKey())));
                continue;
            }
            if (!Objects.equals((Object)coordinate.getType(), (Object)Coordinate.ParametersType.OBJECT)) continue;
            coordinateHandler.handler(coordinate.getKey(), TypeToString.ObjectToString(coordinate.getMethod().invoke(object, new Object[0])));
        }
        coordinateHandler.clean();
    }

    public static class HandleMethod {
        private RequestInfo requestInfo;
        private Method method;
        private Serialize serialize;
        private Integer requestTimes = 30000;
        private Object success;
        private Object fail;
        private ReturnMode returnMode;

        public RequestInfo getRequestInfo() {
            return this.requestInfo;
        }

        public void setRequestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
        }

        public Method getMethod() {
            return this.method;
        }

        public void setMethod(Method method) {
            this.method = method;
        }

        public Serialize getSerialize() {
            return this.serialize;
        }

        public void setSerialize(Serialize serialize) {
            this.serialize = serialize;
        }

        public Integer getRequestTimes() {
            return this.requestTimes;
        }

        public void setRequestTimes(Integer requestTimes) {
            this.requestTimes = requestTimes;
        }

        public Object getSuccess() {
            return this.success;
        }

        public void setSuccess(Object success) {
            this.success = success;
        }

        public Object getFail() {
            return this.fail;
        }

        public void setFail(Object fail) {
            this.fail = fail;
        }

        public ReturnMode getReturnMode() {
            return this.returnMode;
        }

        public void setReturnMode(ReturnMode returnMode) {
            this.returnMode = returnMode;
        }
    }
}

