/*
 * Decompiled with CFR 0.152.
 */
package com.lamp.light.handler;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.QueryStringEncoder;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import java.util.Objects;

public interface CoordinateHandler<T, V> {
    public static final ThreadLocal<CoordinateHandlerWrapper> COORDINATEHANDLER = new ThreadLocal<CoordinateHandlerWrapper>(){

        @Override
        public CoordinateHandlerWrapper initialValue() {
            return new CoordinateHandlerWrapper();
        }
    };

    public static CoordinateHandlerWrapper getCoordinateHandlerWrapper() {
        return COORDINATEHANDLER.get();
    }

    public void handler(String var1, V var2);

    public void clean();

    public static class CoordinateHandlerWrapper {
        public QueryCoordinateHandler queryCoordinateHandler = new QueryCoordinateHandler();
        public FieldCoordinateHandler fieldCoordinateHandler = new FieldCoordinateHandler();
        public PathCoordinateHandler pathCoordinateHandler = new PathCoordinateHandler();
        public HeaderCoordinateHandler headerCoordinateHandler = new HeaderCoordinateHandler();
        public CookieCoordinateHandler cookieCoordinateHandler = new CookieCoordinateHandler();
    }

    public static class UploadCoordinateHandler
    extends AbstractCoordinateHandler<HttpPostRequestEncoder, Object> {
        @Override
        public void handler(String name, Object value) {
            try {
                ((HttpPostRequestEncoder)this.object).addBodyAttribute(name, value.toString());
            }
            catch (HttpPostRequestEncoder.ErrorDataEncoderException e) {
                e.printStackTrace();
            }
        }
    }

    public static class FieldCoordinateHandler
    extends AbstractCoordinateHandler<HttpPostRequestEncoder, String> {
        @Override
        public void handler(String name, String value) {
            try {
                ((HttpPostRequestEncoder)this.object).addBodyAttribute(name, value);
            }
            catch (HttpPostRequestEncoder.ErrorDataEncoderException e) {
                e.printStackTrace();
            }
        }
    }

    public static class QueryCoordinateHandler
    extends AbstractCoordinateHandler<QueryStringEncoder, String> {
        @Override
        public void handler(String name, String value) {
            ((QueryStringEncoder)this.object).addParam(name, value);
        }
    }

    public static class PathCoordinateHandler
    extends AbstractCoordinateHandler<String, String> {
        @Override
        public void handler(String name, String value) {
        }
    }

    public static class HeaderCoordinateHandler
    extends AbstractCoordinateHandler<HttpHeaders, String> {
        @Override
        public void handler(String name, String value) {
            ((HttpHeaders)this.object).add(name, (Object)value);
        }
    }

    public static class CookieCoordinateHandler
    extends AbstractCoordinateHandler<HttpHeaders, String> {
        @Override
        public void handler(String name, String value) {
            String string = ((HttpHeaders)this.object).get((CharSequence)HttpHeaderNames.COOKIE);
            if (Objects.isNull(string)) {
                string = "";
            }
            string = string + ":\"" + value + "\";";
            ((HttpHeaders)this.object).add(name, (Object)string);
        }
    }

    public static abstract class AbstractCoordinateHandler<T, V>
    implements CoordinateHandler<T, V> {
        T object;

        void setObject(T object) {
            this.object = object;
        }

        @Override
        public void clean() {
            this.object = null;
        }
    }
}

