/*
 * Decompiled with CFR 0.152.
 */
package com.lamp.light.handler;

import com.lamp.light.Call;
import com.lamp.light.annotation.Body;
import com.lamp.light.annotation.Cookie;
import com.lamp.light.annotation.GET;
import com.lamp.light.annotation.Header;
import com.lamp.light.annotation.Headers;
import com.lamp.light.annotation.POST;
import com.lamp.light.annotation.Path;
import com.lamp.light.annotation.Query;
import com.lamp.light.handler.Coordinate;
import com.lamp.light.handler.RequestInfo;
import com.lamp.light.response.ReturnMode;
import com.lamp.light.serialize.FastJsonSerialize;
import com.lamp.light.serialize.Serialize;
import com.lamp.light.util.BaseUtils;
import io.netty.handler.codec.http.HttpMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AnnotationAnalysis {
    private static final Map<Class<?>, Class<?>> DATA_ANNOTION = new HashMap();
    private static final Map<Class<?>, Method> DATA_ANNOTION_METHOD = new HashMap();
    private static final Set<Class<?>> IS_PACKING = new HashSet();

    public RequestInfo analysis(Class<?> clazz) throws Exception {
        RequestInfo requestInfo = new RequestInfo();
        this.readHeaders(clazz, requestInfo, null);
        this.readHttpMethod(clazz, requestInfo);
        return requestInfo;
    }

    public RequestInfo analysis(Method method, RequestInfo classRequestInfo) throws Exception {
        Class returnType;
        RequestInfo requestInfo = new RequestInfo();
        this.readHeaders(method, requestInfo, classRequestInfo);
        this.readHttpMethod(method, requestInfo);
        if (Objects.isNull(requestInfo.getHttpMethod())) {
            if (Objects.isNull(classRequestInfo.getHttpMethod())) {
                // empty if block
            }
            requestInfo.setUrl(classRequestInfo.getUrl() + "/" + requestInfo.getMethod().getName());
        } else if (Objects.nonNull(classRequestInfo.getHttpMethod())) {
            requestInfo.setUrl(BaseUtils.setSlash(classRequestInfo.getUrl()) + BaseUtils.setSlash(requestInfo.getUrl()));
        }
        Parameter[] parameters = method.getParameters();
        if (Objects.nonNull(parameters) && parameters.length != 0) {
            this.readParameter(parameters, requestInfo);
        }
        if (Void.class.equals(returnType = method.getReturnType())) {
            // empty if block
        }
        if (Call.class.isAssignableFrom(returnType)) {
            requestInfo.setReturnMode(ReturnMode.CALL);
            returnType = (Class)BaseUtils.getParameterUpperBound(0, (ParameterizedType)method.getGenericReturnType());
        } else {
            requestInfo.setReturnMode(ReturnMode.SYNS);
        }
        requestInfo.setReturnClazz(returnType);
        return requestInfo;
    }

    private void readHeaders(AnnotatedElement annotatedElement, RequestInfo requestInfo, RequestInfo classRequestInfo) {
        Headers headers = annotatedElement.getAnnotation(Headers.class);
        if (Objects.nonNull(headers) || Objects.nonNull(classRequestInfo) && Objects.nonNull(classRequestInfo.getHeader())) {
            HashMap<String, String> headerMap = new HashMap<String, String>();
            if (Objects.nonNull(classRequestInfo) && Objects.nonNull(classRequestInfo.getHeader())) {
                headerMap.putAll(classRequestInfo.getHeader());
            }
            if (Objects.nonNull(headers)) {
                String[] values;
                for (String value : values = headers.value()) {
                    String[] headerKeyValue = value.split(":");
                    headerMap.put(headerKeyValue[0], headerKeyValue[1]);
                }
            }
            requestInfo.setHeader(headerMap);
        }
    }

    private void readParameter(Parameter[] parameters, RequestInfo requestInfo) throws Exception {
        HashMap clazzMap = new HashMap();
        for (int index = 0; index < parameters.length; ++index) {
            Parameter parameter = parameters[index];
            Class<?> clazz = parameter.getType();
            Annotation[] annotations = parameter.getAnnotations();
            if (Objects.isNull(null) || annotations.length == 0) {
                // empty if block
            }
            for (Annotation annotation : annotations) {
                Class<?> dataClazz = DATA_ANNOTION.get(annotation.annotationType());
                Coordinate.ParametersType type = this.getParametersType(clazz, dataClazz);
                if (Objects.isNull(dataClazz)) continue;
                ArrayList<Coordinate> coordinateList = (ArrayList<Coordinate>)clazzMap.get(dataClazz);
                if (Objects.isNull(coordinateList)) {
                    coordinateList = new ArrayList<Coordinate>();
                    clazzMap.put(dataClazz, coordinateList);
                }
                String[] values = (String[])DATA_ANNOTION_METHOD.get(dataClazz).invoke((Object)annotation, new Object[0]);
                if (Objects.equals((Object)type, (Object)Coordinate.ParametersType.BASIC) || Objects.equals((Object)type, (Object)Coordinate.ParametersType.PACKING) || Objects.equals((Object)type, (Object)Coordinate.ParametersType.STRING)) {
                    if (values.length == 0 || values.length > 1) {
                        // empty if block
                    }
                    AnnotationAnalysis.createCoordinate(coordinateList, values[0], index, type, null);
                    continue;
                }
                if (Objects.equals((Object)type, (Object)Coordinate.ParametersType.MAP)) {
                    if (values.length == 0) {
                        AnnotationAnalysis.createCoordinate(coordinateList, null, index, type, null);
                        continue;
                    }
                    for (String value : values) {
                        AnnotationAnalysis.createCoordinate(coordinateList, value, index, type, null);
                    }
                    continue;
                }
                if (!Objects.equals((Object)type, (Object)Coordinate.ParametersType.OBJECT)) continue;
                if (values.length == 0) {
                    AnnotationAnalysis.getCoordinateByClass(clazz, index, type, coordinateList);
                    continue;
                }
                for (String value : values) {
                    AnnotationAnalysis.createCoordinate(coordinateList, value, index, Coordinate.ParametersType.OBJECT, AnnotationAnalysis.getMethod(value, clazz));
                }
            }
        }
        requestInfo.setHeaderList((List)clazzMap.get(Header.class));
        requestInfo.setPathList((List)clazzMap.get(Path.class));
        requestInfo.setQueryList((List)clazzMap.get(Query.class));
        requestInfo.setFieldList((List)clazzMap.get(com.lamp.light.annotation.Field.class));
    }

    private void readHttpMethod(AnnotatedElement annotatedElement, RequestInfo requestInfo) throws InstantiationException, IllegalAccessException {
        POST post = annotatedElement.getAnnotation(POST.class);
        if (Objects.nonNull(post)) {
            requestInfo.setHttpMethod(HttpMethod.POST);
            requestInfo.setUrl(post.value());
            Body body = annotatedElement.getAnnotation(Body.class);
            if (Objects.nonNull(body)) {
                requestInfo.setIsBody(true);
                Class<?> serializeClass = body.serialize();
                Serialize serialize = serializeClass.equals(FastJsonSerialize.class) ? new FastJsonSerialize() : (Serialize)body.getClass().newInstance();
                requestInfo.setSerialize(serialize);
            }
            return;
        }
        GET get = annotatedElement.getAnnotation(GET.class);
        if (Objects.nonNull(get)) {
            requestInfo.setHttpMethod(HttpMethod.GET);
            requestInfo.setUrl(get.value());
        }
    }

    private static void getCoordinateByClass(Class<?> clazz, int index, Coordinate.ParametersType type, List<Coordinate> coordinateList) {
        Field[] fields;
        for (Field field : fields = clazz.getFields()) {
            String fieldName = field.getName();
            Method method = AnnotationAnalysis.getMethod(fieldName, clazz);
            if (!Objects.isNull(method)) continue;
            AnnotationAnalysis.createCoordinate(coordinateList, fieldName, index, type, method);
        }
    }

    private static Boolean createCoordinate(List<Coordinate> coordinateList, String key, int index, Coordinate.ParametersType type, Method method) {
        Coordinate coordinate = new Coordinate();
        coordinate.setIndex(index);
        coordinate.setType(type);
        coordinate.setKey(key);
        coordinate.setMethod(method);
        coordinateList.add(coordinate);
        return true;
    }

    private static Method getMethod(String name, Class<?> clazz) {
        String methodName = "get" + name.substring(0, 1).toUpperCase() + name.substring(1, name.length());
        try {
            Method method = clazz.getMethod(methodName, new Class[0]);
            if (Objects.isNull(method)) {
                methodName = "is" + name.substring(0, 1).toLowerCase() + name.substring(1, name.length());
                method = clazz.getMethod(methodName, new Class[0]);
            }
            return method;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    private Coordinate.ParametersType getParametersType(Class<?> clazz, Class<?> dataClazz) {
        if (clazz.isPrimitive()) {
            return Coordinate.ParametersType.BASIC;
        }
        if (IS_PACKING.contains(clazz)) {
            return Coordinate.ParametersType.PACKING;
        }
        if (String.class.equals(clazz)) {
            return Coordinate.ParametersType.STRING;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return Coordinate.ParametersType.MAP;
        }
        return Coordinate.ParametersType.OBJECT;
    }

    static {
        DATA_ANNOTION.put(Header.class, Header.class);
        DATA_ANNOTION.put(Cookie.class, Cookie.class);
        DATA_ANNOTION.put(Path.class, Path.class);
        DATA_ANNOTION.put(Query.class, Query.class);
        DATA_ANNOTION.put(com.lamp.light.annotation.Field.class, com.lamp.light.annotation.Field.class);
        DATA_ANNOTION.put(Body.class, Body.class);
        for (Class<?> clazz : DATA_ANNOTION.keySet()) {
            try {
                DATA_ANNOTION_METHOD.put(clazz, clazz.getMethod("value", new Class[0]));
            }
            catch (NoSuchMethodException | SecurityException exception) {}
        }
        IS_PACKING.add(Long.class);
        IS_PACKING.add(Integer.class);
        IS_PACKING.add(Short.class);
        IS_PACKING.add(Byte.class);
        IS_PACKING.add(Double.class);
        IS_PACKING.add(Float.class);
        IS_PACKING.add(Byte.class);
        IS_PACKING.add(Boolean.class);
    }
}

