/*
 * Decompiled with CFR 0.152.
 */
package com.lamp.light;

import com.lamp.light.Interceptor;
import com.lamp.light.handler.HandleProxy;
import com.lamp.light.netty.NettyClient;
import com.lamp.light.serialize.FastJsonSerialize;
import com.lamp.light.serialize.Serialize;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class Light {
    private InetSocketAddress inetSocketAddress;
    private List<Interceptor> interceptorList;
    private Serialize serialize;
    private String path;
    private Executor executor;
    private NettyClient nettyClient;

    private void init() {
        this.nettyClient = new NettyClient(this.executor);
    }

    public <T> T create(Class<?> clazz) throws Exception {
        this.validateServiceInterface(clazz);
        return this.create(clazz, null);
    }

    public <T> T create(Class<?> clazz, Object result) throws Exception {
        return this.create(clazz, result, result);
    }

    public <T> T create(Class<?> clazz, Object success, Object fail) throws Exception {
        return (T)this.getObject(clazz, success, fail);
    }

    private void validateServiceInterface(Class<?> clazz) {
        if (Objects.isNull(clazz)) {
            // empty if block
        }
        if (!clazz.isInterface()) {
            // empty if block
        }
    }

    private Object getObject(Class<?> clazz, Object success, Object fail) throws Exception {
        HandleProxy handleProxy = new HandleProxy(this.nettyClient, this.path, clazz, this.inetSocketAddress, this.interceptorList, this.serialize, success, fail);
        return Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)handleProxy);
    }

    public static Builder Builder() {
        return new Builder();
    }

    public static class Builder {
        private String scheme = "http1.1";
        private String host;
        private int port = 80;
        private String path;
        private Serialize serialize;
        private List<Interceptor> interceptorList;
        private Executor executor;

        public Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder serialize(Serialize serialize) {
            this.serialize = serialize;
            return this;
        }

        public Builder interceptor(Interceptor interceptor) {
            if (this.interceptorList == null) {
                this.interceptorList = new ArrayList<Interceptor>();
            }
            this.interceptorList.add(interceptor);
            return this;
        }

        public Light build() {
            Light light = new Light();
            if (!Objects.isNull(this.host) || "".equals(this.host)) {
                // empty if block
            }
            if (Objects.isNull(this.serialize)) {
                this.serialize = new FastJsonSerialize();
            }
            light.inetSocketAddress = new InetSocketAddress(this.host, this.port);
            light.serialize = this.serialize;
            light.interceptorList = this.interceptorList;
            if (Objects.isNull(this.executor)) {
                this.executor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
                    AtomicInteger atomicInteger = new AtomicInteger();

                    @Override
                    public Thread newThread(Runnable r) {
                        return new Thread("ligth-asyn-" + this.atomicInteger.incrementAndGet());
                    }
                });
            }
            light.path = this.path;
            light.executor = this.executor;
            light.init();
            return light;
        }
    }
}

