/*
 * Decompiled with CFR 0.152.
 */
package cn.lalaki.repack.plugin;

import com.android.builder.model.SigningConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000f\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010+\u001a\u00020,H\u0007J\u0010\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020\u001aH\u0002J \u0010/\u001a\u00020,2\u0006\u00100\u001a\u00020\u00152\u0006\u00101\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u001aH\u0002J#\u00102\u001a\u00020,2\u0006\u00103\u001a\u00020\u001a2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u00a2\u0006\u0002\u00105J \u00106\u001a\u00020,2\u0006\u00100\u001a\u00020\u00152\u0006\u00107\u001a\u00020\u001a2\u0006\u00108\u001a\u00020\u0015H\u0002J\u0010\u00109\u001a\u00020,2\u0006\u0010:\u001a\u00020\u0015H\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\bR \u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\bR\u001c\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\bR\u001c\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\bR\u001c\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\bR\u001c\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\bR\u001c\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010!0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\bR\u001c\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\bR\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcn/lalaki/repack/plugin/RepackingTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "disabled", "Lorg/gradle/api/provider/Property;", "", "getDisabled", "()Lorg/gradle/api/provider/Property;", "quiet", "getQuiet", "resign", "getResign", "addV1Sign", "getAddV1Sign", "addV2Sign", "getAddV2Sign", "disableV3V4", "getDisableV3V4", "blacklist", "", "", "getBlacklist", "sevenZip", "getSevenZip", "apkFile", "Ljava/io/File;", "getApkFile", "outputFile", "getOutputFile", "sdkHome", "getSdkHome", "signConfig", "Lcom/android/builder/model/SigningConfig;", "getSignConfig", "minSdk", "getMinSdk", "builder", "Ljava/lang/ProcessBuilder;", "sevenZipUrl", "sevenZipMirror", "resultCode", "", "main", "", "cleanBuildDir", "buildDir", "unPackProc", "a7zString", "output", "deleteBlackListFile", "file", "array", "(Ljava/io/File;[Ljava/lang/String;)V", "repackProc", "a7zApk", "repackPath", "sPrintln", "msg", "plugin"})
@SourceDebugExtension(value={"SMAP\nRepackingTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepackingTask.kt\ncn/lalaki/repack/plugin/RepackingTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,361:1\n1855#2,2:362\n*S KotlinDebug\n*F\n+ 1 RepackingTask.kt\ncn/lalaki/repack/plugin/RepackingTask\n*L\n268#1:362,2\n*E\n"})
public abstract class RepackingTask
extends DefaultTask {
    @NotNull
    private final ProcessBuilder builder = new ProcessBuilder(new String[0]);
    @NotNull
    private final String sevenZipUrl;
    @NotNull
    private final String sevenZipMirror;
    private int resultCode = -1;

    public RepackingTask() {
        this.sevenZipUrl = "https://www.7-zip.org/";
        this.sevenZipMirror = "https://repo1.maven.org/maven2/cn/lalaki/AndResGuard/SevenZip/1.3.8-beta01/SevenZip-1.3.8-beta01-windows-x86_64.exe";
    }

    @Optional
    @Input
    @NotNull
    public abstract Property<Boolean> getDisabled();

    @Optional
    @Input
    @NotNull
    public abstract Property<Boolean> getQuiet();

    @Optional
    @Input
    @NotNull
    public abstract Property<Boolean> getResign();

    @Optional
    @Input
    @NotNull
    public abstract Property<Boolean> getAddV1Sign();

    @Optional
    @Input
    @NotNull
    public abstract Property<Boolean> getAddV2Sign();

    @Optional
    @Input
    @NotNull
    public abstract Property<Boolean> getDisableV3V4();

    @Optional
    @Input
    @NotNull
    public abstract Property<String[]> getBlacklist();

    @Optional
    @Input
    @NotNull
    public abstract Property<String> getSevenZip();

    @Optional
    @Input
    @NotNull
    public abstract Property<File> getApkFile();

    @Optional
    @Input
    @NotNull
    public abstract Property<File> getOutputFile();

    @Optional
    @Input
    @NotNull
    public abstract Property<File> getSdkHome();

    @Optional
    @Input
    @NotNull
    public abstract Property<SigningConfig> getSignConfig();

    @Optional
    @Input
    @NotNull
    public abstract Property<String> getMinSdk();

    @TaskAction
    public final void main() {
        Object object;
        String[] child;
        String a7z;
        String[] checkApkSigner;
        Object checkZipalign;
        Object[] buildTools;
        this.sPrintln("[ APK Repacking Task Started!#" + ProcessHandle.current().pid() + " ]\n");
        File sdkHome = (File)this.getSdkHome().getOrNull();
        if (sdkHome == null || !sdkHome.exists()) {
            throw new IllegalStateException("missing sdk directory!".toString());
        }
        File toolHome = new File(sdkHome.getAbsolutePath(), "build-tools");
        File buildTool = null;
        File zipAlign = null;
        String[] apkSigner = null;
        String string = System.getenv("OS");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getenv(...)");
        boolean isWin = StringsKt.contains((CharSequence)string, (CharSequence)"windows", (boolean)true);
        String alignName = "zipalign";
        String signName = "apksigner";
        if (isWin) {
            alignName = "zipalign.exe";
            signName = "apksigner.bat";
        }
        if (toolHome.exists() && (buildTools = toolHome.listFiles()) != null) {
            List list = ArraysKt.reversed((Object[])buildTools);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                File tool = (File)list.get(i);
                if (tool.isDirectory()) {
                    buildTool = tool;
                    checkZipalign = new File(buildTool, alignName);
                    if (((File)checkZipalign).exists()) {
                        zipAlign = checkZipalign;
                    }
                    if ((checkApkSigner = new File(buildTool, signName)).exists()) {
                        apkSigner = checkApkSigner;
                    }
                }
                if (zipAlign != null && apkSigner != null) break;
            }
        }
        if (buildTool == null || !buildTool.exists()) {
            throw new IllegalStateException("missing build tool!".toString());
        }
        this.sPrintln("build tool: " + buildTool.getName());
        File customOutput = (File)this.getApkFile().getOrNull();
        File output = (File)this.getOutputFile().getOrNull();
        if (customOutput != null && customOutput.exists()) {
            output = customOutput;
        }
        if (output == null || !output.exists()) {
            throw new IllegalStateException("missing output apk!".toString());
        }
        File v4Sig = new File(output.getAbsolutePath() + ".idsig");
        if (v4Sig.exists()) {
            v4Sig.delete();
        }
        if ((a7z = (String)this.getSevenZip().getOrNull()) == null || StringsKt.startsWith$default((String)a7z, (String)"http", (boolean)false, (int)2, null)) {
            String string2 = this.getProject().getGradle().getGradleUserHomeDir().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
            checkZipalign = string2;
            checkApkSigner = new String[]{"caches\\7za.exe"};
            Path path = Paths.get((String)checkZipalign, Arrays.copyOf(checkApkSigner, checkApkSigner.length));
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            Path auto7z = path;
            String currentMirror = this.sevenZipMirror;
            String string3 = a7z;
            boolean bl = string3 != null ? StringsKt.startsWith$default((String)string3, (String)"http", (boolean)false, (int)2, null) : false;
            if (bl) {
                currentMirror = a7z;
            }
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isRegularFile(auto7z, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                FileUtils.copyURLToFile((URL)URI.create(currentMirror).toURL(), (File)auto7z.toFile());
            }
            a7z = ((Object)auto7z.toAbsolutePath()).toString();
        }
        Path path = Paths.get(a7z, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path a7zExe = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isRegularFile(a7zExe, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new IllegalStateException(("missing 7-zip tool! please download: " + this.sevenZipUrl).toString());
        }
        String a7zString = ((Object)a7zExe.toAbsolutePath()).toString();
        this.sPrintln("7z: " + a7zString);
        File buildDir = new File(output.getParent(), ".tmp_" + UUID.randomUUID());
        String string4 = buildDir.getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getCanonicalPath(...)");
        String[] stringArray = new String[]{File.separator};
        List wdArr = StringsKt.split$default((CharSequence)string4, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (!((Collection)wdArr).isEmpty()) {
            Object tempPath = "";
            Iterator iterator = ((Iterable)wdArr).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int i = n++;
                child = (String[])iterator.next();
                if (i <= wdArr.size() - 4) continue;
                tempPath = (String)tempPath + File.separator + (String)child;
            }
            this.sPrintln("working directory: .." + (String)tempPath);
        }
        File a7zApk = new File(output.getParent(), buildDir.getName() + ".apk");
        this.unPackProc(a7zString, output, buildDir);
        String[] blacklist = (String[])this.getBlacklist().getOrNull();
        if (blacklist != null) {
            this.deleteBlackListFile(buildDir, blacklist);
        }
        String repackPath = buildDir.getAbsolutePath() + File.separator;
        this.repackProc(a7zString, a7zApk, repackPath);
        File arscFile = new File(repackPath + "resources.arsc");
        if (arscFile.isFile()) {
            child = new String[]{a7zString, "a", "-bd", "-mtm-", "-tzip", a7zApk.getAbsolutePath(), "-mx0", arscFile.getCanonicalPath()};
            this.resultCode = this.builder.command(child).start().waitFor();
            if (this.resultCode != 0) {
                throw new IllegalStateException("add resources.arsc failed!".toString());
            }
        }
        if (output.exists()) {
            FilesKt.copyTo$default((File)output, (File)new File(output.getParent(), "backup.apk"), (boolean)true, (int)0, (int)4, null);
        }
        if ((object = zipAlign) == null || (object = ((File)object).getAbsolutePath()) == null) {
            throw new IllegalStateException("missing zipalign tool!".toString());
        }
        Object alignExe = object;
        String[] stringArray2 = new String[]{alignExe, "-f", "4", a7zApk.getAbsolutePath(), output.getAbsolutePath()};
        this.resultCode = this.builder.command(stringArray2).start().waitFor();
        if (a7zApk.exists()) {
            a7zApk.delete();
        }
        this.cleanBuildDir(buildDir);
        if (this.resultCode != 0) {
            throw new IllegalStateException("zipAlign failed!".toString());
        }
        this.sPrintln("zipAligned: ok");
        String minSdkVersion = (String)this.getMinSdk().getOrElse((Object)"21");
        SigningConfig signConfig = (SigningConfig)this.getSignConfig().getOrNull();
        if (signConfig != null && Intrinsics.areEqual((Object)this.getResign().getOrNull(), (Object)true)) {
            File storeFile = signConfig.getStoreFile();
            if (storeFile != null && storeFile.exists()) {
                Object object2 = apkSigner;
                if (apkSigner == null || (object2 = object2.getAbsolutePath()) == null) {
                    throw new IllegalStateException("missing sign tool!".toString());
                }
                Object signBat = object2;
                String[] stringArray3 = new String[]{signBat, "sign", "--min-sdk-version", minSdkVersion, "--v1-signer-name", "_", "--v1-signing-enabled", ((Boolean)this.getAddV1Sign().getOrElse((Object)false)).toString(), "--v2-signing-enabled", ((Boolean)this.getAddV2Sign().getOrElse((Object)false)).toString(), "--v3-signing-enabled", String.valueOf((Boolean)this.getDisableV3V4().getOrElse((Object)true) == false), "--v4-signing-enabled", String.valueOf((Boolean)this.getDisableV3V4().getOrElse((Object)true) == false), "--ks", storeFile.getAbsolutePath(), "--ks-key-alias", signConfig.getKeyAlias(), "--ks-pass", "pass:" + signConfig.getStorePassword(), "--key-pass", "pass:" + signConfig.getKeyPassword(), output.getAbsolutePath()};
                this.resultCode = this.builder.command(stringArray3).start().waitFor();
                if (this.resultCode != 0) {
                    throw new IllegalStateException("sign failed!".toString());
                }
                Object[] objectArray = new String[]{apkSigner.getAbsolutePath(), "verify", "-v"};
                ArrayList verCmd = CollectionsKt.arrayListOf((Object[])objectArray);
                if (v4Sig.exists()) {
                    verCmd.add("-v4-signature-file");
                    verCmd.add(v4Sig.getAbsolutePath());
                }
                verCmd.add(output.getAbsolutePath());
                Process verifyProc = this.builder.command(verCmd).start();
                this.resultCode = verifyProc.waitFor();
                if (this.resultCode != 0) {
                    throw new IllegalStateException("verify failed!".toString());
                }
                BufferedReader reader = verifyProc.inputReader();
                Object schemes = null;
                schemes = "";
                Regex regex = new Regex("(v\\S*) ");
                Intrinsics.checkNotNull((Object)reader);
                Iterable $this$forEach$iv = TextStreamsKt.readLines((Reader)reader);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MatchResult data;
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.contains((CharSequence)it, (CharSequence)"true", (boolean)true) || (data = Regex.find$default((Regex)regex, (CharSequence)it, (int)0, (int)2, null)) == null) continue;
                    schemes = schemes + data.getValue();
                }
                reader.close();
                this.sPrintln("signed: ok, " + schemes);
            }
        } else {
            this.sPrintln("missing signConfig or no need sign, skip");
        }
        if (((Boolean)this.getDisableV3V4().get()).booleanValue() && !((Boolean)this.getAddV2Sign().get()).booleanValue() && Integer.parseInt(String.valueOf(minSdkVersion)) < 30) {
            this.unPackProc(a7zString, output, buildDir);
            this.repackProc(a7zString, output, repackPath);
            this.sPrintln("info: v1 signature only, compressed again.");
            this.cleanBuildDir(buildDir);
        }
        this.sPrintln("apk: " + output.getAbsolutePath());
        this.sPrintln("\n[ Done ]");
    }

    private final void cleanBuildDir(File buildDir) {
        if (buildDir.exists()) {
            FilesKt.deleteRecursively((File)buildDir);
        }
    }

    private final void unPackProc(String a7zString, File output, File buildDir) {
        String[] stringArray = new String[]{a7zString, "x", output.getAbsolutePath(), "-o" + buildDir.getAbsolutePath(), "-y"};
        this.resultCode = this.builder.command(stringArray).start().waitFor();
        if (this.resultCode != 0 || buildDir.listFiles() == null) {
            throw new IllegalStateException("unpack failed!".toString());
        }
    }

    private final void deleteBlackListFile(File file, String[] array) {
        String rootDir = file.getAbsolutePath();
        for (String blackItem : array) {
            Path deleteItem;
            Intrinsics.checkNotNull((Object)rootDir);
            String string = rootDir;
            String[] stringArray = new String[]{blackItem};
            Intrinsics.checkNotNullExpressionValue((Object)Paths.get(string, Arrays.copyOf(stringArray, stringArray.length)), (String)"get(...)");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(deleteItem, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.isDirectory(deleteItem, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                PathsKt.deleteRecursively((Path)deleteItem);
            } else {
                LinkOption[] linkOptionArray3 = new LinkOption[]{};
                if (Files.isRegularFile(deleteItem, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
                    Files.delete(deleteItem);
                }
            }
            this.sPrintln("blacklist: remove the file or directory - " + StringsKt.replace$default((String)((Object)deleteItem.toAbsolutePath()).toString(), (String)rootDir, (String)"", (boolean)false, (int)4, null));
        }
    }

    private final void repackProc(String a7zString, File a7zApk, String repackPath) {
        String[] stringArray = new String[]{a7zString, "a", "-bd", "-mtm-", "-tzip", a7zApk.getAbsolutePath(), "-mfb258", "-mpass=15", "-mx9", repackPath + "*"};
        this.resultCode = this.builder.command(stringArray).start().waitFor();
        if (this.resultCode != 0) {
            throw new IllegalStateException("repack failed!".toString());
        }
    }

    private final void sPrintln(String msg) {
        if (!((Boolean)this.getQuiet().getOrElse((Object)false)).booleanValue()) {
            System.out.println((Object)msg);
        }
    }
}

