/*
 * Decompiled with CFR 0.152.
 */
package cn.lalaki.pub.tasks;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.io.inputstream.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.CompressionLevel;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.internal.hash.HashCode;

public class ChecksumTask
extends DefaultTask {
    private AbstractArchiveTask archive;
    private final HashMap<String, String> hashWithExt = new HashMap<String, String>(){
        {
            this.put("MD5", ".md5");
            this.put("SHA-1", ".sha1");
            this.put("SHA-256", ".sha256");
            this.put("SHA-512", ".sha512");
            this.put("", "");
        }
    };
    private final ZipParameters params = new ZipParameters();

    public void calculateFor(AbstractArchiveTask archive) throws IllegalStateException {
        if (this.archive != null && this.archive != archive) {
            throw new IllegalStateException("Already calculating checksum for " + this.archive);
        }
        this.dependsOn(new Object[]{archive});
        this.archive = archive;
    }

    public String toString() {
        return "Checksum for " + this.archive;
    }

    private byte[] hex(byte[] bytes) {
        return HashCode.fromBytes((byte[])bytes).toString().getBytes(StandardCharsets.UTF_8);
    }

    public File outputFile() {
        File archiveFile = ((RegularFile)this.archive.getArchiveFile().get()).getAsFile();
        String ext = "." + (String)this.archive.getArchiveExtension().get();
        String name = archiveFile.getName().substring(0, archiveFile.getName().length() - ext.length());
        return new File(archiveFile.getParentFile(), name + "-checksum" + ext);
    }

    @TaskAction
    public void writeChecksums() throws IOException {
        File archiveFile = ((RegularFile)this.archive.getArchiveFile().get()).getAsFile();
        this.params.setCompressionLevel(CompressionLevel.ULTRA);
        try (ZipFile bundleZip = new ZipFile(this.outputFile());
             ZipFile zipArchive = new ZipFile(archiveFile);){
            for (FileHeader headers : zipArchive.getFileHeaders()) {
                if (headers.isDirectory()) continue;
                String fileName = headers.getFileName();
                ZipInputStream fileStream = zipArchive.getInputStream(headers);
                try {
                    byte[] fileData = fileStream.readAllBytes();
                    this.hashWithExt.forEach((alg, ext) -> this.addFileToZip(bundleZip, fileName + ext, alg.isEmpty() ? fileData : this.getCheckSum(fileData, (String)alg)));
                }
                finally {
                    if (fileStream == null) continue;
                    fileStream.close();
                }
            }
        }
    }

    private void addFileToZip(ZipFile zipFile, String name, byte[] data) {
        this.params.setFileNameInZip(name);
        try (ByteArrayInputStream fileStream = new ByteArrayInputStream(data);){
            zipFile.addStream((InputStream)fileStream, this.params);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] getCheckSum(byte[] data, String algorithm) {
        try {
            return this.hex(MessageDigest.getInstance(algorithm).digest(data));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

