/*
 * Decompiled with CFR 0.152.
 */
package cn.lalaki.pub;

import cn.lalaki.pub.internal.BaseCentralPortalExtension;
import cn.lalaki.pub.platform.AndroidPlatform;
import cn.lalaki.pub.platform.BasePlatform;
import cn.lalaki.pub.platform.JavaPlatform;
import cn.lalaki.pub.tasks.BasePublishToCentralPortalTask;
import cn.lalaki.pub.tasks.ChecksumTask;
import java.util.Objects;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RelativePath;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.BasePluginExtension;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublicationContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPom;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.plugins.MavenPublishPlugin;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.plugins.signing.Sign;
import org.gradle.plugins.signing.SigningExtension;
import org.gradle.plugins.signing.SigningPlugin;

public class MavenCentralPublisherPlugin
implements Plugin<Project> {
    static final String GROUP = "central portal publishing";
    static final String ANDROID_LIBRARY = "com.android.library";

    public static BasePlatform detectPlatform(Logger log, Project target) {
        log.info("Detecting the Gradle project platform");
        if (target.getPlugins().hasPlugin(ANDROID_LIBRARY)) {
            return new AndroidPlatform(log, target);
        }
        return new JavaPlatform();
    }

    public static void applyNecessaryPlugins(Logger log, Project target) {
        log.info("Applying the `maven-publish` and `signing` plugins");
        PluginManager pluginManager = target.getPluginManager();
        pluginManager.apply(MavenPublishPlugin.class);
        pluginManager.apply(SigningPlugin.class);
    }

    public static BaseCentralPortalExtension setupExtension(Logger log, ExtensionContainer extensions) throws IllegalArgumentException {
        log.info("Setting up the `centralPortal` extension");
        return (BaseCentralPortalExtension)extensions.create("centralPortal", BaseCentralPortalExtension.class, new Object[0]);
    }

    public static JarTasks setupJarTasks(Logger log, BasePlatform platform, Project target, TaskContainer tasks, Provider<String> artifactIdProvider) throws InvalidUserDataException {
        FileTree mainSources = platform.mainSourceSetSources(log, target);
        log.info("Setting up the `:sourcesJar` task");
        Jar sourcesJarTask = (Jar)tasks.create("sourcesJar", Jar.class);
        sourcesJarTask.setGroup(GROUP);
        sourcesJarTask.setDescription("Creates a `-sources` jar.");
        sourcesJarTask.getArchiveClassifier().set((Object)"sources");
        sourcesJarTask.from(new Object[]{mainSources});
        Task javadocTask = platform.javadocTask(log, target, tasks, mainSources, artifactIdProvider);
        log.info("Setting up the `:javadocJar` task");
        Jar javadocJarTask = (Jar)tasks.create("javadocJar", Jar.class);
        javadocJarTask.setGroup(GROUP);
        javadocJarTask.setDescription("Creates a `-javadoc` jar");
        javadocJarTask.getArchiveClassifier().set((Object)"javadoc");
        javadocJarTask.from(new Object[]{javadocTask});
        return new JarTasks(sourcesJarTask, javadocJarTask);
    }

    public static MavenPublication setupPublication(Logger log, Project target, BasePlatform platform, ExtensionContainer extensions, TaskContainer tasks, JarTasks jarTasks, BaseCentralPortalExtension centralPortalExtension, Provider<String> artifactIdProvider, Provider<String> nameProvider) throws UnknownDomainObjectException, InvalidUserDataException {
        log.info("Setting up the `centralPortal` publication");
        PublishingExtension publishingExtension = (PublishingExtension)extensions.getByType(PublishingExtension.class);
        PublicationContainer publications = publishingExtension.getPublications();
        MavenPublication mavenCentralPortalPublication = (MavenPublication)publications.create("centralPortal", MavenPublication.class);
        target.afterEvaluate(project -> {
            String name = (String)artifactIdProvider.get();
            mavenCentralPortalPublication.setArtifactId(name);
            Task jarTask = (Task)centralPortalExtension.getJarTask().getOrNull();
            if (jarTask == null) {
                jarTask = platform.jarTask(log, tasks);
            }
            mavenCentralPortalPublication.artifact((Object)jarTask);
            mavenCentralPortalPublication.artifact(centralPortalExtension.getSourcesJarTask().getOrElse((Object)jarTasks.sourcesJarTask));
            mavenCentralPortalPublication.artifact(centralPortalExtension.getJavadocJarTask().getOrElse((Object)jarTasks.javadocJarTask));
            mavenCentralPortalPublication.from(platform.component(log, target));
            mavenCentralPortalPublication.versionMapping(centralPortalExtension::configureVersionMapping);
            ((MavenPublicationInternal)mavenCentralPortalPublication).setModuleDescriptorGenerator(null);
            mavenCentralPortalPublication.pom(pom -> {
                pom.getName().set((Object)((String)nameProvider.getOrElse((Object)((String)artifactIdProvider.get()))));
                pom.getDescription().set((Object)target.getDescription());
                pom.setPackaging(platform.defaultPackaging());
                centralPortalExtension.configurePom((MavenPom)pom);
            });
        });
        return mavenCentralPortalPublication;
    }

    public static Sign setupSigning(Logger log, Project target, MavenPublication mavenCentralPortalPublication) throws UnknownDomainObjectException {
        log.info("Setting up the signing of the `centralPortal` publication");
        SigningExtension signingExtension = (SigningExtension)target.getExtensions().getByType(SigningExtension.class);
        return (Sign)signingExtension.sign(new Publication[]{mavenCentralPortalPublication}).get(0);
    }

    public static ChecksumTask setupBundleTasks(Logger log, Project target, TaskContainer tasks, MavenPublicationInternal publication, Provider<String> artifactIdProvider) throws InvalidUserDataException {
        log.info("Setting up the `:generateBundle` task");
        Zip generateBundleTask = (Zip)tasks.create("generateBundle", Zip.class);
        generateBundleTask.setGroup(GROUP);
        generateBundleTask.setDescription("Creates a bundle for Sonatype Central Portal publishing.");
        generateBundleTask.getArchiveClassifier().set((Object)"bundle");
        generateBundleTask.into(() -> {
            String[] groupParts = Objects.toString(target.getGroup()).split("\\.");
            String name = (String)artifactIdProvider.get();
            String version = Objects.toString(target.getVersion());
            return new RelativePath(false, groupParts).append(false, new String[]{name, version});
        });
        FileCollection publishableMavenArtifacts = publication.getPublishableArtifacts().getFiles();
        generateBundleTask.from((Object)publishableMavenArtifacts, file -> file.rename(n -> n.replace("pom-default.xml", (String)artifactIdProvider.get() + "-" + target.getVersion() + ".pom")));
        Provider bundlesDir = target.getLayout().getBuildDirectory().dir("bundles");
        generateBundleTask.getDestinationDirectory().set(bundlesDir);
        ChecksumTask checksumTask = (ChecksumTask)tasks.create("checksumBundle", ChecksumTask.class);
        checksumTask.setGroup(GROUP);
        checksumTask.setDescription("Generates `.md5` and `.sha1` checksums of the `:generateBundle` output.");
        checksumTask.calculateFor((AbstractArchiveTask)generateBundleTask);
        return checksumTask;
    }

    public static void setupPublishToCentralPortalTask(Logger log, TaskContainer tasks, ChecksumTask checksumTask) {
        log.info("Setting up the `:publishToCentralPortal` task");
        BasePublishToCentralPortalTask publishToCentralPortalTask = (BasePublishToCentralPortalTask)tasks.create("publishToCentralPortal", BasePublishToCentralPortalTask.class);
        publishToCentralPortalTask.setGroup(GROUP);
        publishToCentralPortalTask.setDescription("Publishes the bundle to Sonatype Central Portal");
        publishToCentralPortalTask.upload(checksumTask);
    }

    public void apply(Project target) {
        Logger log = target.getLogger();
        MavenCentralPublisherPlugin.applyNecessaryPlugins(log, target);
        BasePlatform platform = MavenCentralPublisherPlugin.detectPlatform(log, target);
        ExtensionContainer extensions = target.getExtensions();
        BaseCentralPortalExtension centralPortalExtension = MavenCentralPublisherPlugin.setupExtension(log, extensions);
        Provider nameProvider = centralPortalExtension.getName().orElse((Object)target.getRootProject().getName());
        Provider artifactIdProvider = centralPortalExtension.getArtifactId().orElse(nameProvider);
        target.afterEvaluate(ignored -> {
            BasePluginExtension ext = (BasePluginExtension)target.getExtensions().findByType(BasePluginExtension.class);
            if (ext != null) {
                ext.getArchivesName().set((Object)((String)artifactIdProvider.get()));
            }
        });
        TaskContainer tasks = target.getTasks();
        JarTasks jarTasks = MavenCentralPublisherPlugin.setupJarTasks(log, platform, target, tasks, (Provider<String>)artifactIdProvider);
        MavenPublication mavenCentralPortalPublication = MavenCentralPublisherPlugin.setupPublication(log, target, platform, extensions, tasks, jarTasks, centralPortalExtension, (Provider<String>)artifactIdProvider, (Provider<String>)nameProvider);
        MavenCentralPublisherPlugin.setupSigning(log, target, mavenCentralPortalPublication);
        ChecksumTask checksumTask = MavenCentralPublisherPlugin.setupBundleTasks(log, target, tasks, (MavenPublicationInternal)mavenCentralPortalPublication, (Provider<String>)artifactIdProvider);
        MavenCentralPublisherPlugin.setupPublishToCentralPortalTask(log, tasks, checksumTask);
    }

    public record JarTasks(Jar sourcesJarTask, Jar javadocJarTask) {
    }
}

