package cn.lalaki.pub.platform;

import org.gradle.api.Project;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.jvm.tasks.Jar;

/**
 * Created on yyyy-MM-dd
 *
 * @author thebugmc
 * @since JavaPlatForm
 * <p>
 * {@code java} platform that assumes Java plugin classes are available.
 */
public final class JavaPlatform extends BasePlatform {
    @Override
    public FileTree mainSourceSetSources(Logger log, Project target) {
        log.info("Detecting the `main` Java sources");
        return target
                .getExtensions()
                .getByType(SourceSetContainer.class)
                .getByName(SourceSet.MAIN_SOURCE_SET_NAME)
                .getAllSource();
    }

    @Override
    public String defaultPackaging() {
        return "jar";
    }

    @Override
    public Jar jarTask(Logger log, TaskContainer tasks) {
        log.info("Detecting the `:jar` task");
        return (Jar) tasks.getByName("jar");
    }

    @Override
    public Javadoc javadocTask(
            Logger log,
            Project target,
            TaskContainer tasks,
            FileTree mainSourceSetSources,
            Provider<String> nameProvider
    ) {
        log.info("Detecting the `:javadoc` task");
        return (Javadoc) tasks.getByName("javadoc");
    }

    @Override
    public SoftwareComponent component(
            Logger log,
            Project target
    ) throws UnknownDomainObjectException {
        log.info("Detecting the `java` component");
        return target.getComponents().getByName("java");
    }
}
