package cn.lalaki.pub.platform;

import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.bundling.Zip;

/**
 * Platform helps the plugin figure out the differences between various kinds of projects (thanks
 * Android for making a very different platform).
 * <p>
 * Created on yyyy-MM-dd
 *
 * @author thebugmc
 * @since BasePlatform
 **/
public abstract class BasePlatform {
    /**
     * {@link FileTree} that represents all sources of a {@code main} task.
     *
     * @param log    log
     * @param target target
     * @return none
     */
    public abstract FileTree mainSourceSetSources(Logger log, Project target);

    /**
     * The default POM {@code packaging} value (e.g. {@code jar}, {@code aar}, etc).
     *
     * @return packaging
     */
    public abstract String defaultPackaging();

    /**
     * Task that generates the main artifact.
     *
     * @param log   log
     * @param tasks tasks
     * @return jarTask
     */
    public abstract Zip jarTask(Logger log, TaskContainer tasks);

    /**
     * Task that generates the {@code ...-javadoc.jar} artifact.
     *
     * @param log                  log
     * @param target               target
     * @param tasks                tasks
     * @param mainSourceSetSources sources
     * @param nameProvider         name
     * @return none
     * @throws UnknownDomainObjectException When some platform is trying to find the task.
     */
    public abstract Task javadocTask(
            Logger log,
            Project target,
            TaskContainer tasks,
            FileTree mainSourceSetSources,
            Provider<String> nameProvider
    ) throws UnknownDomainObjectException;

    /**
     * Something like {@code components.java} or its alternatives.
     *
     * @param log    log
     * @param target target
     * @return none
     * @throws UnknownDomainObjectException When the platform is supposed to search for a necessary
     *                                      component but is unable to find it.
     */
    public abstract SoftwareComponent component(Logger log, Project target) throws UnknownDomainObjectException;
}
