package cn.lalaki.pub.internal;

import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.provider.Property;
import org.gradle.api.publish.VersionMappingStrategy;
import org.gradle.api.publish.maven.MavenPom;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.tasks.Optional;

/***
 * Created on yyyy-MM-dd
 *
 * @author thebugmc
 * @since BaseCentralPortalExtension
 */
@SuppressWarnings("unused")
public abstract class BaseCentralPortalExtension implements HasPublicType {
    private Action<? super MavenPom> pomConfigurator;
    private Action<? super VersionMappingStrategy> versionMappingConfigurator;

    public void configurePom(MavenPom pom) {
        if (pomConfigurator != null) {
            pomConfigurator.execute(pom);
        }
    }

    public void configureVersionMapping(VersionMappingStrategy vms) {
        if (versionMappingConfigurator != null) {
            versionMappingConfigurator.execute(vms);
        }
    }

    public void pom(Action<? super MavenPom> configure) {
        pomConfigurator = configure;
    }

    public void versionMapping(Action<? super VersionMappingStrategy> configure) {
        versionMappingConfigurator = configure;
    }

    @Override
    public TypeOf<?> getPublicType() {
        return TypeOf.typeOf(this.getClass());
    }

    /**
     * The user token to use when publishing. Consider using {@code gradle.properties} instead with
     * the {@code centralPortal.username} property.
     *
     * @return Sonatype username
     * @see #getPassword()
     */
    @Optional
    public abstract Property<String> getUsername();

    /**
     * The password to use when publishing. Consider using {@code gradle.properties} instead with
     * the {@code centralPortal.password} property.
     *
     * @return Sonatype password
     * @see #getUsername()
     */
    @Optional
    public abstract Property<String> getPassword();

    /**
     * Sets the {@link PublishingType} for the current publication. The
     * {@link PublishingType#AUTOMATIC} is the default.
     *
     * @return PublishingType
     */
    @Optional
    public abstract Property<PublishingType> getPublishingType();

    /**
     * Grabs the name that will be used throughout the Central Portal plugin, e.g. bundle name,
     * {@code artifactId}, etc. When not specified, {@code rootProject.name} will be used.
     *
     * @return pom file name attr
     */
    @Optional
    public abstract Property<String> getName();

    /**
     * Grabs the name that will be used throughout the Central Portal plugin, e.g. bundle name,
     * {@code artifactId}, etc. When not specified, {@code name} will be used.
     *
     * @return pom file ArtifactId attr
     */
    @Optional
    public abstract Property<String> getArtifactId();

    /**
     * The {@code :jar} task that will be used for generating the base {@code .jar} file (bundle
     * file 2/4).
     *
     * @return jarTask
     */
    @Optional
    public abstract Property<Task> getJarTask();

    /**
     * The {@code :javadoc} task that will be used for generating the {@code ...-javadoc.jar} file
     * (bundle file 3/4). Primarily used for Closed-source publications (when you want your JavaDoc
     * to be empty).
     *
     * @return javaDocTask
     */
    @Optional
    public abstract Property<Task> getJavadocJarTask();

    /**
     * The {@code :sourcesJar} task that will be used for generating the {@code ...-sources.jar}
     * file (bundle file 4/4). Primarily used for Closed-source publications (when you want your
     * sources to be empty).
     *
     * @return JavaSourcesTask
     */
    @Optional
    public abstract Property<Task> getSourcesJarTask();

    /**
     * Determines whether to publish the artifact immediately, or to hold it back behind Publish button
     * in the Sonatype Central Portal panel.
     *
     * @see #AUTOMATIC
     * @see #USER_MANAGED
     */
    public enum PublishingType {
        /**
         * The Publish button will be pressed for you immediately after a successful validation. This is
         * the default.
         */
        AUTOMATIC,
        /**
         * The Publish button will be there for you to press in the Sonatype Central Portal panel.
         */
        USER_MANAGED,
    }
}