/*
 * Decompiled with CFR 0.152.
 */
package net.thebugmc.gradle.sonatypepublisher.tasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.internal.hash.HashCode;

public class ChecksumTask
extends DefaultTask {
    private AbstractArchiveTask archive;
    private final HashMap<String, String> hashWithExt = new HashMap<String, String>(){
        {
            this.put("MD5", ".md5");
            this.put("SHA-1", ".sha1");
            this.put("SHA-256", ".sha256");
            this.put("SHA-512", ".sha512");
        }
    };

    public void calculateFor(AbstractArchiveTask archive) throws IllegalStateException {
        if (this.archive != null && this.archive != archive) {
            throw new IllegalStateException("Already calculating checksum for " + this.archive);
        }
        this.dependsOn(new Object[]{archive});
        this.archive = archive;
    }

    public String toString() {
        return "Checksum for " + this.archive;
    }

    private byte[] hex(byte[] bytes) {
        return HashCode.fromBytes((byte[])bytes).toString().getBytes(StandardCharsets.UTF_8);
    }

    public File outputFile() {
        File archiveFile = ((RegularFile)this.archive.getArchiveFile().get()).getAsFile();
        String ext = "." + (String)this.archive.getArchiveExtension().get();
        String name = archiveFile.getName().substring(0, archiveFile.getName().length() - ext.length());
        return new File(archiveFile.getParentFile(), name + "-checksum" + ext);
    }

    @TaskAction
    public void writeChecksums() throws IOException {
        try (FileOutputStream out = new FileOutputStream(this.outputFile());
             ZipOutputStream zipFile = new ZipOutputStream(out);
             ZipFile oldZipFile = new ZipFile(((RegularFile)this.archive.getArchiveFile().get()).getAsFile());){
            Enumeration<? extends ZipEntry> entries = oldZipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry readEntry = entries.nextElement();
                byte[] data = oldZipFile.getInputStream(readEntry).readAllBytes();
                zipFile.putNextEntry(readEntry);
                zipFile.write(data);
                zipFile.closeEntry();
                if (readEntry.isDirectory()) continue;
                this.hashWithExt.forEach((alg, ext) -> this.addChecksumToZipEntry(zipFile, (String)alg, readEntry.getName() + ext, data));
            }
        }
    }

    private void addChecksumToZipEntry(ZipOutputStream out, String algorithm, String name, byte[] data) {
        try {
            out.putNextEntry(new ZipEntry(name));
            out.write(this.hex(MessageDigest.getInstance(algorithm).digest(data)));
            out.closeEntry();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

