/*
 * Decompiled with CFR 0.152.
 */
package net.thebugmc.gradle.sonatypepublisher.tasks;

import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Base64;
import java.util.Objects;
import net.thebugmc.gradle.sonatypepublisher.internal.BaseCentralPortalExtension;
import net.thebugmc.gradle.sonatypepublisher.tasks.ChecksumTask;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;

public abstract class BasePublishToCentralPortalTask
extends DefaultTask {
    public final String UPLOAD_ENDPOINT = "https://central.sonatype.com/api/v1/publisher/upload?publishingType=";
    private ChecksumTask checksumTask;

    public void upload(ChecksumTask checksumTask) {
        if (this.checksumTask != null && checksumTask != this.checksumTask) {
            throw new IllegalArgumentException("Checksum task already set to " + this.checksumTask);
        }
        this.dependsOn(new Object[]{checksumTask});
        this.checksumTask = checksumTask;
    }

    @TaskAction
    public void sendRequest() throws IOException {
        Project target = this.getProject();
        BaseCentralPortalExtension extension = (BaseCentralPortalExtension)target.getExtensions().getByType(BaseCentralPortalExtension.class);
        String username = (String)extension.getUsername().getOrElse((Object)Objects.toString(target.findProperty("centralPortal.username")));
        String password = (String)extension.getPassword().getOrElse((Object)Objects.toString(target.findProperty("centralPortal.password")));
        if (username.isEmpty() || password.isEmpty()) {
            String valueIsNull = username.isEmpty() ? "username" : "password";
            throw new IOException("Missing PublishToCentralPortal's `(" + valueIsNull + ")`, `centralPortal." + valueIsNull + "` value and `centralPortal." + valueIsNull + "` property");
        }
        this.publishToMaven(username, password, ((BaseCentralPortalExtension.PublishingType)((Object)extension.getPublishingType().getOrElse((Object)BaseCentralPortalExtension.PublishingType.AUTOMATIC))).name(), URLEncoder.encode(this.getProject().getGroup() + ":" + (String)extension.getName().orElse((Object)target.getRootProject().getName()).get() + ":" + this.getProject().getVersion(), Charset.defaultCharset()), this.checksumTask.outputFile());
    }

    private void publishToMaven(String username, String password, String publishingType, String bundleName, File outputFile) throws IOException {
        try (Response resp = new OkHttpClient().newCall(new Request.Builder().url("https://central.sonatype.com/api/v1/publisher/upload?publishingType=" + publishingType + "&name=" + bundleName).addHeader("Authorization", "Bearer " + Base64.getEncoder().encodeToString((username + ":" + password).getBytes())).post((RequestBody)new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("bundle", "bundle.zip", RequestBody.create((byte[])Files.readAllBytes(outputFile.toPath()))).build()).build()).execute();){
            if (!resp.isSuccessful()) {
                throw new IOException("Error " + resp.code() + ": " + resp.message());
            }
        }
    }
}

