/*
 * Decompiled with CFR 0.152.
 */
package net.thebugmc.gradle.sonatypepublisher.internal;

import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.provider.Property;
import org.gradle.api.publish.VersionMappingStrategy;
import org.gradle.api.publish.maven.MavenPom;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.tasks.Optional;

public abstract class BaseCentralPortalExtension
implements HasPublicType {
    private Action<? super MavenPom> pomConfigurator;
    private Action<? super VersionMappingStrategy> versionMappingConfigurator;

    public void configurePom(MavenPom pom) {
        if (this.pomConfigurator != null) {
            this.pomConfigurator.execute((Object)pom);
        }
    }

    public void configureVersionMapping(VersionMappingStrategy vms) {
        if (this.versionMappingConfigurator != null) {
            this.versionMappingConfigurator.execute((Object)vms);
        }
    }

    public void pom(Action<? super MavenPom> configure) {
        this.pomConfigurator = configure;
    }

    public void versionMapping(Action<? super VersionMappingStrategy> configure) {
        this.versionMappingConfigurator = configure;
    }

    public TypeOf<?> getPublicType() {
        return TypeOf.typeOf(this.getClass());
    }

    @Optional
    public abstract Property<String> getUsername();

    @Optional
    public abstract Property<String> getPassword();

    @Optional
    public abstract Property<PublishingType> getPublishingType();

    @Optional
    public abstract Property<String> getName();

    @Optional
    public abstract Property<String> getArtifactId();

    @Optional
    public abstract Property<Task> getJarTask();

    @Optional
    public abstract Property<Task> getJavadocJarTask();

    @Optional
    public abstract Property<Task> getSourcesJarTask();

    public static enum PublishingType {
        AUTOMATIC,
        USER_MANAGED;

    }
}

