/*
 * Decompiled with CFR 0.152.
 */
package net.thebugmc.gradle.sonatypepublisher.platform;

import com.android.build.api.dsl.LibraryPublishing;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.api.DefaultAndroidSourceDirectorySet;
import com.android.build.gradle.tasks.BundleAar;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Unit;
import net.thebugmc.gradle.sonatypepublisher.platform.Platform;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.jetbrains.dokka.gradle.DokkaTask;

public final class AndroidLibraryPlatform
implements Platform {
    public static final String COMPONENT_NAME = "default";

    public AndroidLibraryPlatform(Logger log, Project target) {
        log.info("Setting up Android publishing");
        LibraryExtension android = (LibraryExtension)target.getExtensions().getByType(LibraryExtension.class);
        LibraryPublishing publishing = android.getPublishing();
        publishing.multipleVariants(COMPONENT_NAME, a -> {
            a.includeBuildTypeValues(new String[]{"release"});
            return Unit.INSTANCE;
        });
    }

    @Override
    public FileTree mainSourceSetSources(Logger log, Project target) {
        log.info("Detecting the `main` Android sources");
        AndroidSourceSet mainSourceSet = (AndroidSourceSet)((LibraryExtension)target.getExtensions().getByType(LibraryExtension.class)).getSourceSets().getByName("main");
        FileTree java = mainSourceSet.getJava().getSourceFiles();
        FileTree kotlin = ((DefaultAndroidSourceDirectorySet)mainSourceSet.getKotlin()).getSourceFiles();
        return java.plus(kotlin);
    }

    public BundleAar jarTask(Logger log, TaskContainer tasks) {
        log.info("Detecting the `:bundleReleaseAar` task");
        BundleAar aar = (BundleAar)tasks.getByName("bundleReleaseAar");
        Property version = aar.getArchiveVersion();
        if (!version.isPresent()) {
            throw new InvalidUserDataException("Your Android project is not setup for publishing. Please follow the plugin installation guide: https://gitlab.com/thebugmc/sonatype-central-portal-publisher#plugin");
        }
        aar.getArchiveFileName().set((Object)((String)aar.getArchiveFileName().get()).replaceAll("(.*)-release.aar", "$1-%s.aar".formatted(version.getOrElse((Object)"unspecified"))));
        return aar;
    }

    @Override
    public Task javadocTask(Logger log, Project target, TaskContainer tasks, FileTree mainSourceSetSources, Provider<String> nameProvider) {
        if (target.getPlugins().hasPlugin("org.jetbrains.dokka")) {
            log.info("Detecting Dokka `:dokkaJavadoc` task (via `org.jetbrains.dokka`)");
            DokkaTask task = (DokkaTask)tasks.getByName("dokkaJavadoc");
            task.getModuleName().set(nameProvider);
            return task;
        }
        log.info("Generating the Android `:javadoc` Java-only task");
        Javadoc task = (Javadoc)tasks.create("javadoc", Javadoc.class);
        AtomicBoolean detectedKt = new AtomicBoolean();
        task.setSource((Object)mainSourceSetSources.filter(file -> {
            if (file.getName().endsWith(".kt") && !detectedKt.get()) {
                detectedKt.set(true);
                log.warn("Detected `.kt` file that will be ignored by the `:javadoc` task. Install `org.jetbrains.dokka` Gradle plugin to generate JavaDocs for `.kt` files.");
            }
            return file.getName().endsWith(".java");
        }));
        return task;
    }

    @Override
    public String defaultPackaging() {
        return "aar";
    }

    @Override
    public SoftwareComponent component(Logger log, Project target) throws UnknownDomainObjectException {
        return (SoftwareComponent)target.getComponents().getByName(COMPONENT_NAME);
    }
}

