/*
 * Decompiled with CFR 0.152.
 */
package net.thebugmc.gradle.sonatypepublisher;

import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import net.thebugmc.gradle.sonatypepublisher.CentralPortalExtension;
import net.thebugmc.gradle.sonatypepublisher.Checksum;
import net.thebugmc.gradle.sonatypepublisher.PublishingType;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public abstract class PublishToCentralPortal
extends DefaultTask {
    public static final String UPLOAD_ENDPOINT = "https://central.sonatype.com/api/v1/publisher/upload?publishingType=";
    private Checksum checksumTask;

    public void upload(Checksum checksumTask) {
        if (this.checksumTask != null && checksumTask != this.checksumTask) {
            throw new IllegalArgumentException("Checksum task already set to " + this.checksumTask);
        }
        this.dependsOn(new Object[]{checksumTask});
        this.checksumTask = checksumTask;
    }

    @Input
    @Optional
    public abstract Property<String> getUsername();

    @Input
    @Optional
    public abstract Property<String> getPassword();

    @TaskAction
    public void sendRequest() throws IOException {
        Project target = this.getProject();
        CentralPortalExtension extension = (CentralPortalExtension)target.getExtensions().getByType(CentralPortalExtension.class);
        String username = (String)this.getUsername().getOrNull();
        if (username == null) {
            username = (String)extension.getUsername().getOrElse((Object)Objects.toString(target.findProperty("centralPortal.username"), ""));
        }
        String password = (String)this.getPassword().getOrElse((Object)((String)extension.getPassword().getOrElse((Object)Objects.toString(target.findProperty("centralPortal.password"), ""))));
        if (username.isEmpty() || password.isEmpty()) {
            String valueIsNull = username.isEmpty() ? "username" : "password";
            throw new IOException("Missing PublishToCentralPortal's `(" + valueIsNull + ")`, `centralPortal." + valueIsNull + "` value and `centralPortal." + valueIsNull + "` property");
        }
        Provider nameProvider = extension.getName().orElse((Object)target.getRootProject().getName());
        this.publishToMaven(username, password, (PublishingType)((Object)extension.getPublishingType().getOrElse((Object)PublishingType.AUTOMATIC)), URLEncoder.encode(this.getProject().getGroup() + ":" + (String)nameProvider.get() + ":" + this.getProject().getVersion(), StandardCharsets.UTF_8), this.checksumTask.outputFile());
    }

    private void publishToMaven(String username, String password, PublishingType publishingType, String bundleName, File outputFile) throws IOException {
        OkHttpClient client = new OkHttpClient();
        String token = Base64.getEncoder().encodeToString((username + ":" + password).getBytes());
        String boundary = Long.toHexString(System.currentTimeMillis() ^ 0xFFFFFFFFFFFFFFFFL);
        MultipartBody requestBody = new MultipartBody.Builder(boundary).setType(MultipartBody.FORM).addFormDataPart("bundle", "bundle.zip", RequestBody.create((File)outputFile, (MediaType)MediaType.parse((String)"application/octet-stream"))).build();
        Request request = new Request.Builder().url(UPLOAD_ENDPOINT + publishingType + "&name=" + bundleName).post((RequestBody)requestBody).addHeader("Authorization", "UserToken " + token).build();
        try (Response resp = client.newCall(request).execute();){
            if (!resp.isSuccessful()) {
                throw new IOException("Error " + resp.code() + ": " + resp.message());
            }
        }
    }
}

