/*
 * Decompiled with CFR 0.152.
 */
package com.lucky.testng;

import com.lucky.testng.ClassDescriptor;
import com.lucky.testng.DiscoveryHelper;
import com.lucky.testng.MethodDescriptor;
import com.lucky.testng.TestListener;
import com.lucky.testng.TestNg;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import org.junit.platform.commons.util.ClassFilter;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.platform.engine.support.filter.ClasspathScanningSupport;
import org.testng.ITestNGListener;
import org.testng.TestNG;
import org.testng.annotations.Test;

public class TestNGine
implements TestEngine {
    static String ENGINE_ID = "lucky-testng-engine";
    static String ENGINE_DISPLAY_NAME = "TestNG TestEngine SPIKE";

    public String getId() {
        return ENGINE_ID;
    }

    public Optional<String> getGroupId() {
        return Optional.of("com.lucky");
    }

    public Optional<String> getArtifactId() {
        return Optional.of("lucky-testng-engine");
    }

    public Optional<String> getVersion() {
        return Optional.of("DEVELOPMENT");
    }

    public TestDescriptor discover(EngineDiscoveryRequest request, UniqueId uniqueId) {
        EngineDescriptor engine = new EngineDescriptor(uniqueId, ENGINE_DISPLAY_NAME);
        ClassFilter filter = ClassFilter.of((Predicate)ClasspathScanningSupport.buildClassNamePredicate((EngineDiscoveryRequest)request), ClassDescriptor::isCandidate);
        DiscoveryHelper helper = new DiscoveryHelper(request, filter);
        helper.discover(engine, this::handle);
        return engine;
    }

    private void handle(EngineDescriptor engine, Class<?> candidate) {
        ClassDescriptor container = ClassDescriptor.newContainerDescriptor(engine.getUniqueId(), candidate);
        Arrays.stream(candidate.getMethods()).filter(method -> method.isAnnotationPresent(Test.class)).map(method -> MethodDescriptor.newMethodDescriptor(container.getUniqueId(), method)).forEach(method -> container.addChild((TestDescriptor)method));
        if (container.getChildren().isEmpty()) {
            return;
        }
        engine.addChild((TestDescriptor)container);
    }

    private void generateTestAnnotation(Method method) throws Exception {
        TestNg testNg = method.getAnnotation(TestNg.class);
        if (testNg == null) {
            return;
        }
        ClassPool pool = ClassPool.getDefault();
        CtClass cc = pool.get(method.getDeclaringClass().getName());
        ClassFile ccFile = cc.getClassFile();
        ConstPool constpool = ccFile.getConstPool();
        CtMethod ctMethod = cc.getDeclaredMethod(method.getName());
        javassist.bytecode.annotation.Annotation annotation = new javassist.bytecode.annotation.Annotation("org.testng.annotations.Test", constpool);
        AnnotationsAttribute attribute = new AnnotationsAttribute(constpool, "RuntimeVisibleAnnotations");
        List attributeInfoList = ctMethod.getMethodInfo().getAttributes();
        attribute.setAnnotation(annotation);
        attributeInfoList.add(attribute);
        cc.toClass();
        Test test = method.getAnnotation(Test.class);
        Class<?> methodClass = Class.forName("java.lang.reflect.Method");
        methodClass.getConstructor(Class.class, String.class, Class[].class, Class.class, Class[].class, Integer.TYPE, Integer.TYPE, String.class, byte[].class, byte[].class, byte[].class, Object.class);
        Annotation[] annotations = method.getDeclaredAnnotations();
    }

    public void execute(ExecutionRequest request) {
        TestDescriptor engine = request.getRootTestDescriptor();
        EngineExecutionListener engineListener = request.getEngineExecutionListener();
        engineListener.executionStarted(engine);
        for (TestDescriptor classDescriptor : engine.getChildren()) {
            engineListener.executionStarted(classDescriptor);
            UniqueId classId = classDescriptor.getUniqueId();
            Class[] testClasses = new Class[]{((ClassDescriptor)classDescriptor).getTestClass()};
            TestNG testNG = new TestNG(false);
            testNG.addListener((ITestNGListener)new TestListener(engineListener, classId));
            testNG.setTestClasses(testClasses);
            testNG.run();
            engineListener.executionFinished(classDescriptor, TestExecutionResult.successful());
        }
        engineListener.executionFinished(engine, TestExecutionResult.successful());
    }
}

