package cn.ktorfitx.server.ksp.message

import cn.ktorfitx.common.ksp.util.message.message

internal val MESSAGE_MISSING_GRADLE_PLUGIN = message {
	english { "Please add id(\"cn.ktorfitx.server\") to build.gradle.kts" }
	chinese { "请在 build.gradle.kts 中添加 id(\"cn.ktorfitx.server\")" }
}

internal val MESSAGE_FUNCTION_TOP_LEVEL_OR_OBJECT_ONLY = message {
	english { "The {1} function can only be declared at the top level of a file or within an object class." }
	chinese { "{1} 函数只允许声明在 文件顶层 或 object 类中" }
}

internal val MESSAGE_FUNCTION_NOT_ALLOWED_TO_CONTAIN_GENERICS = message {
	english { "The {1} function does not allow the use of generics." }
	chinese { "{1} 函数不允许包含泛型" }
}

internal val MESSAGE_FUNCTION_FAILED_PARSE_FOLLOWING_PATH_PARAMETER = message {
	english { "The {1} function failed to parse the following {2} Path parameter." }
	chinese { "{1} 函数未解析以下 {2} Path 参数" }
}

internal val MESSAGE_FUNCTION_NOT_ALLOW_USE_BODY_FIELD_PART_ANNOTATION = message {
	english { "The {1} function does not allow the simultaneous use of the @Body annotation, the @Field annotation, and the @PartForm, @PartFile, @PartBinary, and @PartBinaryChannel annotations." }
	chinese { "{1} 函数不允许同时使用 @Body 注解、@Field 注解 以及 @PartForm、@PartFile、@PartBinary、@PartBinaryChannel 注解" }
}

internal val MESSAGE_FUNCTION_PARAMETER_NOT_ALLOW_USE_MULTIPLE_BODY = message {
	english { "The {1} function parameter does not allow the use of multiple @Body." }
	chinese { "{1} 函数参数不允许同时使用多个 @Body 注解" }
}

internal val MESSAGE_FUNCTION_NOT_ALLOW_USE_UNIT_AND_NOTHING = message {
	english { "The {1} function does not allow using Unit or Nothing as the return type." }
	chinese { "{1} 函数不允许使用 Unit 或 Nothing 作为返回类型" }
}

internal val MESSAGE_FUNCTION_RETURN_TYPE_NOT_MEET_SERIALIZATION_REQUIREMENTS = message {
	english { "The return type of the {1} function does not satisfy the serialization requirements.. Please check if it complies with the rules of Kotlinx Serialization." }
	chinese { "{1} 函数的返回类型不满足序列化要求，请检查该类型是否符合 Kotlinx Serialization 规则" }
}

internal val MESSAGE_FUNCTION_IS_WEBSOCKET_TYPE_SO_RETURN_TYPE_ONLY_USE_UNIT_TYPE = message {
	english { "The {1} function is annotated with the {2} annotation, so the return type can only be of the Unit type." }
	chinese { "{1} 函数标注了 {2} 注解，因此返回类型只允许是 Unit 类型" }
}

internal val MESSAGE_FUNCTION_NOT_ALLOW_ADDING_MULTIPLE_REQUEST_TYPES_SIMULTANEOUSLY = message {
	english { "The {1} function does not allow adding multiple request types at the same time." }
	chinese { "{1} 函数不允许同时添加多个请求类型" }
}

internal val MESSAGE_FUNCTION_ONLY_ALLOW_CREATION_OF_EXTENSION_METHODS_FOR_DEFAULT_WEB_SOCKET_SERVER_SESSION = message {
	english { "The {1} function only allows the creation of extension methods for the DefaultWebSocketServerSession type." }
	chinese { "{1} 函数仅允许为 DefaultWebSocketServerSession 类型创建扩展方法" }
}

internal val MESSAGE_FUNCTION_ONLY_ALLOW_CREATION_OF_EXTENSION_METHODS_FOR_WEB_SOCKET_SERVER_SESSION = message {
	english { "The {1} function only allows the creation of extension methods for the WebSocketServerSession type." }
	chinese { "{1} 函数仅允许为 WebSocketServerSession 类型创建扩展方法" }
}

internal val MESSAGE_FUNCTION_ONLY_ALLOW_CREATION_OF_EXTENSION_METHODS_FOR_ROUTING_CONTEXT = message {
	english { "The {1} function only allows the creation of extension methods for the RoutingContext type." }
	chinese { "{1} 函数仅允许为 RoutingContext 类型创建扩展方法" }
}

internal val MESSAGE_PARAMETER_WAS_NOT_FOUND_IN_THE_URL = message {
	english { "The {2} parameter of the {1} function was not found in the url." }
	chinese { "{1} 函数的 {2} 参数未在 url 中找到" }
}

internal val MESSAGE_PARAMETER_REDUNDANTLY_PARSED_AS_THE_PATH_PARAMETER = message {
	english { "The {2} parameter of the {1} function is redundantly parsed as the path parameter." }
	chinese { "{1} 函数的 {2} 参数重复解析 Path 参数" }
}

internal val MESSAGE_PARAMETER_NOT_ALLOWED_NULLABLE = message {
	english { "The {2} parameter of the {1} function is not allowed to be null." }
	chinese { "{1} 函数的 {2} 参数不允许为可空类型" }
}

internal val MESSAGE_PARAMETER_MUST_USE_ONE_OF_ANNOTATIONS = message {
	english { "The {2} parameter of the {1} function must use one of the annotations in {3}." }
	chinese { "{1} 函数的 {2} 参数必须使用 {3} 注解中的一个" }
}

internal val MESSAGE_PARAMETER_ONLY_USE_ONE_OF_ANNOTATIONS = message {
	english { "The {2} parameter of the {1} function is restricted to use only one of the annotations in {3}." }
	chinese { "{1} 函数的 {2} 参数只允许使用 {3} 注解中的一个" }
}

internal val MESSAGE_PARAMETER_NULLABLE_ONLY_STRING = message {
	english { "The {2} parameter of the {1} function is restricted to be of a nullable String type." }
	chinese { "{1} 函数的 {2} 参数只允许 String 为可空类型" }
}

internal val MESSAGE_PARAMETER_RETRIEVED_TWICE_WITH_PART_PARAMETER = message {
	english { "The {2} parameter of the {1} function is retrieved twice with the parameter {3}." }
	chinese { "{1} 函数的 {2} 参数重复获取了 {3} 参数" }
}

internal val MESSAGE_PARAMETER_ONLY_USE_STRING = message {
	english { "The {2} parameter of the {1} function is restricted to accepting only String type values." }
	chinese { "{1} 函数的 {2} 参数只允许使用 String 类型" }
}

internal val MESSAGE_PARAMETER_ONLY_USE_STRING_OR_FORM_ITEM = message {
	english { "The {2} parameter of the {1} function can only accept String and PartData.FormItem types." }
	chinese { "{1} 函数的 {2} 参数只允许使用 String 和 PartData.FormItem 类型" }
}

internal val MESSAGE_PARAMETER_ONLY_USE_FILE_ITEM = message {
	english { "The {2} parameter of the {1} function can only use the PartData.FileItem type." }
	chinese { "{1} 函数的 {2} 参数只允许使用 PartData.FileItem 类型" }
}

internal val MESSAGE_PARAMETER_ONLY_USE_BYTE_ARRAY_OR_BINARY_ITEM = message {
	english { "The {2} parameter of the {1} function can only be of the types ByteArray and PartData.BinaryItem." }
	chinese { "{1} 函数的 {2} 参数只允许使用 ByteArray 和 PartData.BinaryItem 类型" }
}

internal val MESSAGE_PARAMETER_ONLY_USE_BINARY_CHANNEL_ITEM = message {
	english { "The {2} parameter of the {1} function can only be of the PartData.BinaryChannelItem type." }
	chinese { "{1} 函数的 {2} 参数只允许使用 PartData.BinaryChannelItem 类型" }
}

internal val MESSAGE_PARAMETER_TYPE_NOT_MEET_SERIALIZATION_REQUIREMENTS = message {
	english { "The type of the {2} parameter of the {1} function does not satisfy serialization requirements. Please check if it complies with the rules of Kotlinx Serialization." }
	chinese { "{1} 函数的 {2} 参数的类型不满足序列化要求，请检查该类型是否符合 Kotlinx Serialization 规则" }
}

internal val MESSAGE_ANNOTATION_NOT_ALLOW_USE_SAME_PATH_PARAMETER = message {
	english { "The {2} annotation of the {1} function does not allow the use of the same {3} parameter for the Path." }
	chinese { "{1} 函数上的 {2} 注解中不允许使用相同的 Path 参数 {3}" }
}

internal val MESSAGE_ANNOTATION_NOT_ALLOW_USE_REGEX_WHEN_WEBSOCKET_HAS_BEEN_MARKED = message {
	english { "The {1} function does not allow the use of the @Regex annotation when the {2} annotation is already present." }
	chinese { "{1} 函数不允许在标注了 {2} 注解的情况下使用 @Regex 注解" }
}

internal val MESSAGE_ANNOTATION_NOT_ALLOW_USE_TIMEOUT_WHEN_WEBSOCKET_HAS_BEEN_MARKED = message {
	english { "The {1} function does not allow the use of the @Timeout annotation when the {2} annotation is already present." }
	chinese { "{1} 函数不允许在标注了 {2} 注解的情况下使用 @Timeout 注解" }
}

internal val MESSAGE_ANNOTATION_VALUE_PARAMETER_MUST_BE_GREATER_THAN_ZERO = message {
	english { "The value parameter of the {2} annotation on the {1} function must be greater than 0." }
	chinese { "{1} 函数上的 {2} 注解的 value 参数必须大于 0" }
}

internal val MESSAGE_ANNOTATION_PATH_PARAMETER_NOT_VALID_REGULAR_EXPRESSION = message {
	english { "The path parameter of the {2} annotation on the {1} function is not a valid regular expression." }
	chinese { "{1} 函数上的 {2} 注解的 path 参数不是一个合法的正则表达式" }
}

internal val FILE_COMMENT = message {
	english {
		"""
		This file was generated by the "cn.ktorfitx:server-ksp" module during the compilation process based on the annotations.
		All manual modifications will be overwritten during the next build.
		If you need to modify the behavior, please modify the corresponding annotations or source code definitions instead of this file itself.
		
		Generation time: {1}
		""".trimIndent()
	}
	chinese {
		"""
		该文件是由 "cn.ktorfitx:server-ksp" 模块在编译期间根据注解生成的代码，
		所有手动修改将会在下次构建时被覆盖，
		若需修改行为，请修改对应的注解或源代码定义，而不是此文件本身。
		
		生成时间：{1}
		""".trimIndent()
	}
}