/*
 * Decompiled with CFR 0.152.
 */
package cn.ktorfitx.server.ksp.kotlinpoet;

import cn.ktorfitx.common.ksp.util.builders.FileSpecBuilderKt;
import cn.ktorfitx.common.ksp.util.builders.KotlinPoetBuildersKt;
import cn.ktorfitx.server.ksp.constants.ClassNames;
import cn.ktorfitx.server.ksp.model.FunctionModel;
import cn.ktorfitx.server.ksp.model.HttpRequestModel;
import cn.ktorfitx.server.ksp.model.RouteGeneratorModel;
import cn.ktorfitx.server.ksp.model.RouteModel;
import cn.ktorfitx.server.ksp.model.WebSocketModel;
import cn.ktorfitx.server.ksp.model.WebSocketRawModel;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.MemberName;
import com.squareup.kotlinpoet.TypeName;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J(\u0010\u0013\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00140\u0018H\u0002J\u001c\u0010\u001a\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001c\u0010\u001d\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001c\u0010 \u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcn/ktorfitx/server/ksp/kotlinpoet/RouteKotlinPoet;", "", "<init>", "()V", "index", "", "getFileSpec", "Lcom/squareup/kotlinpoet/FileSpec;", "generatorModel", "Lcn/ktorfitx/server/ksp/model/RouteGeneratorModel;", "functionModels", "", "Lcn/ktorfitx/server/ksp/model/FunctionModel;", "getFunctionSpec", "Lcom/squareup/kotlinpoet/FunSpec;", "funName", "", "getCodeBlock", "Lcom/squareup/kotlinpoet/CodeBlock;", "buildAuthenticationIfNeed", "", "Lcom/squareup/kotlinpoet/CodeBlock$Builder;", "functionModel", "block", "Lkotlin/Function1;", "Lcn/ktorfitx/server/ksp/model/RouteModel;", "buildHttpRequest", "httpRequestModel", "Lcn/ktorfitx/server/ksp/model/HttpRequestModel;", "buildWebRawSocket", "webSocketRawModel", "Lcn/ktorfitx/server/ksp/model/WebSocketRawModel;", "buildWebSocket", "webSocketModel", "Lcn/ktorfitx/server/ksp/model/WebSocketModel;", "getLetterSequence", "server-ksp"})
@SourceDebugExtension(value={"SMAP\nRouteKotlinPoet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RouteKotlinPoet.kt\ncn/ktorfitx/server/ksp/kotlinpoet/RouteKotlinPoet\n+ 2 CodeBlock.kt\ncom/squareup/kotlinpoet/CodeBlocks\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n537#2:156\n1869#3,2:157\n1#4:159\n*S KotlinDebug\n*F\n+ 1 RouteKotlinPoet.kt\ncn/ktorfitx/server/ksp/kotlinpoet/RouteKotlinPoet\n*L\n41#1:156\n42#1:157,2\n*E\n"})
public final class RouteKotlinPoet {
    private int index;

    @NotNull
    public final FileSpec getFileSpec(@NotNull RouteGeneratorModel generatorModel, @NotNull List<FunctionModel> functionModels) {
        Intrinsics.checkNotNullParameter((Object)generatorModel, (String)"generatorModel");
        Intrinsics.checkNotNullParameter(functionModels, (String)"functionModels");
        return KotlinPoetBuildersKt.buildFileSpec((String)generatorModel.getPackageName(), (String)generatorModel.getFileName(), arg_0 -> RouteKotlinPoet.getFileSpec$lambda$0(this, generatorModel, functionModels, arg_0));
    }

    private final FunSpec getFunctionSpec(String funName, List<FunctionModel> functionModels) {
        return KotlinPoetBuildersKt.buildFunSpec((String)funName, arg_0 -> RouteKotlinPoet.getFunctionSpec$lambda$1(this, functionModels, arg_0));
    }

    private final CodeBlock getCodeBlock(List<FunctionModel> functionModels) {
        CodeBlock.Builder builder;
        boolean $i$f$buildCodeBlock = false;
        CodeBlock.Builder $this$getCodeBlock_u24lambda_u244 = builder = CodeBlock.Companion.builder();
        boolean bl = false;
        Iterable $this$forEach$iv = functionModels;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FunctionModel functionModel = (FunctionModel)element$iv;
            boolean bl2 = false;
            this.buildAuthenticationIfNeed($this$getCodeBlock_u24lambda_u244, functionModel, (Function1<? super RouteModel, Unit>)((Function1)arg_0 -> RouteKotlinPoet.getCodeBlock$lambda$4$lambda$3$lambda$2(this, $this$getCodeBlock_u24lambda_u244, functionModel, arg_0)));
        }
        return builder.build();
    }

    private final void buildAuthenticationIfNeed(CodeBlock.Builder $this$buildAuthenticationIfNeed, FunctionModel functionModel, Function1<? super RouteModel, Unit> block) {
        if (functionModel.getAuthenticationModel() != null) {
            String[] configurations = functionModel.getAuthenticationModel().getConfigurations();
            ClassName strategy = functionModel.getAuthenticationModel().getStrategy();
            Object[] objectArray = new String[]{"authenticate"};
            FileSpecBuilderKt.getFileSpecBuilder().addImport("io.ktor.server.auth", (String[])objectArray);
            objectArray = new Object[]{strategy};
            $this$buildAuthenticationIfNeed.beginControlFlow(StringsKt.trimIndent((String)("\n\t\t\t\tauthenticate(\n\t\t\t\t\tconfigurations = " + (String)(configurations.length == 0 ? "arrayOf(null)," : "arrayOf(" + configurations + ".joinToString()}),") + "\n\t\t\t\t\tstrategy = %T\n\t\t\t\t)\n\t\t\t\t")), objectArray);
        }
        block.invoke((Object)functionModel.getRouteModel());
        if (functionModel.getAuthenticationModel() != null) {
            $this$buildAuthenticationIfNeed.endControlFlow();
        }
    }

    private final void buildHttpRequest(CodeBlock.Builder $this$buildHttpRequest, FunctionModel functionModel, HttpRequestModel httpRequestModel) {
        Object[] objectArray = new String[]{httpRequestModel.getMethod()};
        FileSpecBuilderKt.getFileSpecBuilder().addImport("io.ktor.server.routing", (String[])objectArray);
        objectArray = new Object[]{httpRequestModel.getPath()};
        $this$buildHttpRequest.beginControlFlow(StringsKt.trimIndent((String)("\n\t\t\t" + httpRequestModel.getMethod() + "(\n\t\t\t\tpath = %S\n\t\t\t)\n\t\t\t")), objectArray);
        int n = this.index;
        this.index = n + 1;
        String alias = this.getLetterSequence(n);
        MemberName memberName = new MemberName(functionModel.getCanonicalName(), functionModel.getFunName(), true);
        FileSpecBuilderKt.getFileSpecBuilder().addAliasedImport(memberName, alias);
        $this$buildHttpRequest.addStatement("val result = " + alias + "()", new Object[0]);
        String[] stringArray = new String[]{"respond"};
        FileSpecBuilderKt.getFileSpecBuilder().addImport("io.ktor.server.response", stringArray);
        $this$buildHttpRequest.addStatement("call.respond(result)", new Object[0]);
        $this$buildHttpRequest.endControlFlow();
    }

    private final void buildWebRawSocket(CodeBlock.Builder $this$buildWebRawSocket, FunctionModel functionModel, WebSocketRawModel webSocketRawModel) {
        CharSequence charSequence;
        Object[] objectArray = new String[]{"webSocketRaw"};
        FileSpecBuilderKt.getFileSpecBuilder().addImport("io.ktor.server.websocket", (String[])objectArray);
        CodeBlock.Builder builder = $this$buildWebRawSocket;
        String string = "webSocketRaw(\n\tpath = %S,\n\tprotocol = %S,\n\tnegotiateExtensions = %L\n)";
        objectArray = new Object[3];
        objectArray[0] = webSocketRawModel.getPath();
        Object[] objectArray2 = objectArray;
        int n = 1;
        CharSequence charSequence2 = webSocketRawModel.getProtocol();
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            int n2 = n;
            Object[] objectArray3 = objectArray2;
            String string2 = string;
            CodeBlock.Builder builder2 = builder;
            boolean bl = false;
            Object var11_13 = null;
            builder = builder2;
            string = string2;
            objectArray2 = objectArray3;
            n = n2;
            charSequence = var11_13;
        } else {
            charSequence = charSequence2;
        }
        objectArray2[n] = charSequence;
        objectArray[2] = webSocketRawModel.getNegotiateExtensions();
        builder.beginControlFlow(string, objectArray);
        int n3 = this.index;
        this.index = n3 + 1;
        String alias = this.getLetterSequence(n3);
        MemberName memberName = new MemberName(functionModel.getCanonicalName(), functionModel.getFunName(), true);
        FileSpecBuilderKt.getFileSpecBuilder().addAliasedImport(memberName, alias);
        $this$buildWebRawSocket.addStatement(alias + "()", new Object[0]);
        $this$buildWebRawSocket.endControlFlow();
    }

    private final void buildWebSocket(CodeBlock.Builder $this$buildWebSocket, FunctionModel functionModel, WebSocketModel webSocketModel) {
        CharSequence charSequence;
        Object[] objectArray = new String[]{"webSocket"};
        FileSpecBuilderKt.getFileSpecBuilder().addImport("io.ktor.server.websocket", (String[])objectArray);
        CodeBlock.Builder builder = $this$buildWebSocket;
        String string = "webSocket(\n\tpath = %S,\n\tprotocol = %S\n)";
        objectArray = new Object[2];
        objectArray[0] = webSocketModel.getPath();
        Object[] objectArray2 = objectArray;
        int n = 1;
        CharSequence charSequence2 = webSocketModel.getProtocol();
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            int n2 = n;
            Object[] objectArray3 = objectArray2;
            String string2 = string;
            CodeBlock.Builder builder2 = builder;
            boolean bl = false;
            Object var11_13 = null;
            builder = builder2;
            string = string2;
            objectArray2 = objectArray3;
            n = n2;
            charSequence = var11_13;
        } else {
            charSequence = charSequence2;
        }
        objectArray2[n] = charSequence;
        builder.beginControlFlow(string, objectArray);
        int n3 = this.index;
        this.index = n3 + 1;
        String alias = this.getLetterSequence(n3);
        MemberName memberName = new MemberName(functionModel.getCanonicalName(), functionModel.getFunName(), true);
        FileSpecBuilderKt.getFileSpecBuilder().addAliasedImport(memberName, alias);
        $this$buildWebSocket.addStatement(alias + "()", new Object[0]);
        $this$buildWebSocket.endControlFlow();
    }

    private final String getLetterSequence(int index) {
        int num = index;
        StringBuilder builder = new StringBuilder();
        do {
            builder.append((char)(97 + num % 26));
        } while ((num = num / 26 - 1) >= 0);
        String string = builder.reverse().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final Unit getFileSpec$lambda$0(RouteKotlinPoet this$0, RouteGeneratorModel $generatorModel, List $functionModels, FileSpec.Builder $this$buildFileSpec) {
        Intrinsics.checkNotNullParameter((Object)$this$buildFileSpec, (String)"$this$buildFileSpec");
        FileSpecBuilderKt.getFileSpecBuilderLocal().set($this$buildFileSpec);
        $this$buildFileSpec.indent("\t");
        FunSpec funSpec = this$0.getFunctionSpec($generatorModel.getFunName(), $functionModels);
        $this$buildFileSpec.addFunction(funSpec);
        FileSpecBuilderKt.getFileSpecBuilderLocal().remove();
        return Unit.INSTANCE;
    }

    private static final Unit getFunctionSpec$lambda$1(RouteKotlinPoet this$0, List $functionModels, FunSpec.Builder $this$buildFunSpec) {
        Intrinsics.checkNotNullParameter((Object)$this$buildFunSpec, (String)"$this$buildFunSpec");
        FunSpec.Builder.receiver$default((FunSpec.Builder)$this$buildFunSpec, (TypeName)((TypeName)ClassNames.INSTANCE.getRouting()), null, (int)2, null);
        CodeBlock codeBlock = this$0.getCodeBlock($functionModels);
        $this$buildFunSpec.addCode(codeBlock);
        return Unit.INSTANCE;
    }

    private static final Unit getCodeBlock$lambda$4$lambda$3$lambda$2(RouteKotlinPoet this$0, CodeBlock.Builder $this_buildCodeBlock, FunctionModel $functionModel, RouteModel routeModel) {
        Intrinsics.checkNotNullParameter((Object)routeModel, (String)"routeModel");
        RouteModel routeModel2 = routeModel;
        if (routeModel2 instanceof HttpRequestModel) {
            this$0.buildHttpRequest($this_buildCodeBlock, $functionModel, (HttpRequestModel)routeModel);
        } else if (routeModel2 instanceof WebSocketRawModel) {
            this$0.buildWebRawSocket($this_buildCodeBlock, $functionModel, (WebSocketRawModel)routeModel);
        } else if (routeModel2 instanceof WebSocketModel) {
            this$0.buildWebSocket($this_buildCodeBlock, $functionModel, (WebSocketModel)routeModel);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
    }
}

