package cn.ktorfitx.server.gradle.plugin

import org.gradle.api.model.ObjectFactory
import org.gradle.kotlin.dsl.newInstance
import org.gradle.kotlin.dsl.property
import javax.inject.Inject

open class KtorfitxServerExtension @Inject constructor(
	objects: ObjectFactory
) {
	
	val websockets = objects.newInstance<WebsocketsConfig>()
	
	val auth = objects.newInstance<MockConfig>()
	
	fun websockets(action: WebsocketsConfig.() -> Unit) {
		websockets.action()
	}
	
	fun auth(action: MockConfig.() -> Unit) {
		auth.action()
	}
}

open class WebsocketsConfig @Inject constructor(objects: ObjectFactory) {
	val enabled = objects.property<Boolean>().convention(false)
}

open class MockConfig @Inject constructor(objects: ObjectFactory) {
	val enabled = objects.property<Boolean>().convention(false)
}