/*
 * Decompiled with CFR 0.152.
 */
package cn.ktorfitx.multiplatform.mock;

import cn.ktorfitx.multiplatform.mock.BodyConfig;
import cn.ktorfitx.multiplatform.mock.CookieConfig;
import cn.ktorfitx.multiplatform.mock.MockRequestBuilder;
import cn.ktorfitx.multiplatform.mock.TimeoutBuilder;
import cn.ktorfitx.multiplatform.mock.config.LogConfig;
import io.ktor.client.plugins.logging.LogLevel;
import io.ktor.client.request.forms.FormPart;
import io.ktor.http.HttpMethod;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J=\u0010\u0014\u001a\u00020\u0011\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0016\u001a\u0002H\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001eJ:\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010!2\u0014\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010!H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006#"}, d2={"Lcn/ktorfitx/multiplatform/mock/MockLogging;", "", "log", "Lcn/ktorfitx/multiplatform/mock/config/LogConfig;", "mockRequest", "Lcn/ktorfitx/multiplatform/mock/MockRequestBuilder;", "urlString", "", "<init>", "(Lcn/ktorfitx/multiplatform/mock/config/LogConfig;Lcn/ktorfitx/multiplatform/mock/MockRequestBuilder;Ljava/lang/String;)V", "getLog", "()Lcn/ktorfitx/multiplatform/mock/config/LogConfig;", "getUrlString", "()Ljava/lang/String;", "urlString$delegate", "Lkotlin/Lazy;", "request", "", "method", "Lio/ktor/http/HttpMethod;", "response", "R", "result", "serializer", "Lkotlinx/serialization/KSerializer;", "format", "Lkotlinx/serialization/StringFormat;", "delay", "", "response$multiplatform_mock", "(Ljava/lang/Object;Lkotlinx/serialization/KSerializer;Lkotlinx/serialization/StringFormat;J)V", "formatUrl", "paths", "", "queries", "multiplatform-mock"})
@SourceDebugExtension(value={"SMAP\nMockLogging.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockLogging.kt\ncn/ktorfitx/multiplatform/mock/MockLogging\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n216#2,2:147\n216#2,2:149\n216#2,2:151\n216#2,2:155\n1869#3,2:153\n1803#3,3:157\n1878#3,3:160\n*S KotlinDebug\n*F\n+ 1 MockLogging.kt\ncn/ktorfitx/multiplatform/mock/MockLogging\n*L\n43#1:147,2\n49#1:149,2\n55#1:151,2\n93#1:155,2\n87#1:153,2\n135#1:157,3\n139#1:160,3\n*E\n"})
public final class MockLogging {
    @NotNull
    private final LogConfig log;
    @NotNull
    private final MockRequestBuilder mockRequest;
    @NotNull
    private final Lazy urlString$delegate;

    public MockLogging(@NotNull LogConfig log, @NotNull MockRequestBuilder mockRequest, @NotNull String urlString) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)mockRequest, (String)"mockRequest");
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        this.log = log;
        this.mockRequest = mockRequest;
        this.urlString$delegate = LazyKt.lazy(() -> MockLogging.urlString_delegate$lambda$0(this, urlString));
    }

    @NotNull
    public final LogConfig getLog() {
        return this.log;
    }

    @NotNull
    public final String getUrlString() {
        Lazy lazy = this.urlString$delegate;
        return (String)lazy.getValue();
    }

    public final void request(@NotNull HttpMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (this.log.getLevel() != LogLevel.NONE) {
            Object value;
            String name;
            FormPart formPart;
            Object element$iv;
            Iterator<Map.Entry<String, Object>> iterator;
            boolean $i$f$forEach;
            Map<String, Object> $this$forEach$iv;
            CharSequence charSequence;
            StringBuilder $this$request_u24lambda_u240 = charSequence = new StringBuilder();
            boolean bl = false;
            if (this.log.getLevel().getInfo()) {
                $this$request_u24lambda_u240.append("REQUEST: " + this.getUrlString()).append('\n');
                $this$request_u24lambda_u240.append("METHOD: " + method.getValue()).append('\n');
                TimeoutBuilder timeout = this.mockRequest.getTimeout$multiplatform_mock();
                if (timeout != null) {
                    $this$request_u24lambda_u240.append("TIMEOUT:").append('\n');
                    if (timeout.getRequestTimeoutMillis() != null) {
                        $this$request_u24lambda_u240.append("-> Request Timeout: " + timeout.getRequestTimeoutMillis() + "ms").append('\n');
                    }
                    if (timeout.getConnectTimeoutMillis() != null) {
                        $this$request_u24lambda_u240.append("-> Connect Timeout: " + timeout.getConnectTimeoutMillis() + "ms").append('\n');
                    }
                    if (timeout.getSocketTimeoutMillis() != null) {
                        $this$request_u24lambda_u240.append("-> Socket Timeout: " + timeout.getSocketTimeoutMillis() + "ms").append('\n');
                    }
                }
            }
            if (this.log.getLevel().getHeaders()) {
                if (!this.mockRequest.getHeaders$multiplatform_mock().isEmpty()) {
                    $this$request_u24lambda_u240.append("HEADERS: COUNT=" + this.mockRequest.getHeaders$multiplatform_mock().size()).append('\n');
                    $this$forEach$iv = this.mockRequest.getHeaders$multiplatform_mock();
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        formPart = element$iv = iterator.next();
                        boolean bl2 = false;
                        name = formPart.getKey();
                        value = formPart.getValue();
                        $this$request_u24lambda_u240.append("-> " + name + ": " + value).append('\n');
                    }
                }
                if (!this.mockRequest.getAttributes$multiplatform_mock().isEmpty()) {
                    $this$request_u24lambda_u240.append("ATTRIBUTES: COUNT=" + this.mockRequest.getAttributes$multiplatform_mock().size()).append('\n');
                    $this$forEach$iv = this.mockRequest.getAttributes$multiplatform_mock();
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        formPart = element$iv = iterator.next();
                        boolean bl3 = false;
                        name = (String)formPart.getKey();
                        value = formPart.getValue();
                        $this$request_u24lambda_u240.append("-> " + name + ": " + value).append('\n');
                    }
                }
                if (!this.mockRequest.getCookies$multiplatform_mock().isEmpty()) {
                    $this$request_u24lambda_u240.append("COOKIES: COUNT=" + this.mockRequest.getCookies$multiplatform_mock().size()).append('\n');
                    $this$forEach$iv = this.mockRequest.getCookies$multiplatform_mock();
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        StringBuilder stringBuilder;
                        formPart = element$iv = iterator.next();
                        boolean bl4 = false;
                        name = (String)formPart.getKey();
                        value = (CookieConfig)formPart.getValue();
                        StringBuilder $this$request_u24lambda_u240_u242_u240 = stringBuilder = new StringBuilder();
                        boolean bl5 = false;
                        $this$request_u24lambda_u240_u242_u240.append("-> " + name + ": " + value);
                        if (((CookieConfig)value).getMaxAge() > 0) {
                            $this$request_u24lambda_u240_u242_u240.append(", max-age=" + (CookieConfig)value);
                        }
                        if (((CookieConfig)value).getExpires() != null) {
                            $this$request_u24lambda_u240_u242_u240.append(", expires=" + ((CookieConfig)value).getExpires());
                        }
                        if (((CookieConfig)value).getDomain() != null) {
                            $this$request_u24lambda_u240_u242_u240.append(", domain=" + ((CookieConfig)value).getDomain());
                        }
                        if (((CookieConfig)value).getPath() != null) {
                            $this$request_u24lambda_u240_u242_u240.append(", path=" + ((CookieConfig)value).getPath());
                        }
                        if (((CookieConfig)value).getSecure()) {
                            $this$request_u24lambda_u240_u242_u240.append(", secure=true");
                        }
                        if (((CookieConfig)value).getHttpOnly()) {
                            $this$request_u24lambda_u240_u242_u240.append(", httpOnly=true");
                        }
                        if (!((CookieConfig)value).getExtensions().isEmpty()) {
                            $this$request_u24lambda_u240_u242_u240.append(", extensions=" + ((CookieConfig)value).getExtensions());
                        }
                        String value2 = stringBuilder.toString();
                        $this$request_u24lambda_u240.append("-> " + name + ": " + value2).append('\n');
                    }
                }
            }
            if (this.log.getLevel().getBody()) {
                if (!((Collection)this.mockRequest.getParts$multiplatform_mock()).isEmpty()) {
                    $this$request_u24lambda_u240.append("FORMS: COUNT=" + this.mockRequest.getParts$multiplatform_mock().size()).append('\n');
                    $this$forEach$iv = this.mockRequest.getParts$multiplatform_mock();
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv.iterator();
                    while (iterator.hasNext()) {
                        element$iv = iterator.next();
                        formPart = element$iv;
                        boolean bl6 = false;
                        name = formPart.component1();
                        value = formPart.component2();
                        $this$request_u24lambda_u240.append("-> " + name + ": " + value).append('\n');
                    }
                }
                if (!this.mockRequest.getFields$multiplatform_mock().isEmpty()) {
                    $this$request_u24lambda_u240.append("FIELDS: COUNT=" + this.mockRequest.getFields$multiplatform_mock().size()).append('\n');
                    $this$forEach$iv = this.mockRequest.getFields$multiplatform_mock();
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        formPart = element$iv = iterator.next();
                        boolean bl7 = false;
                        name = (String)formPart.getKey();
                        value = formPart.getValue();
                        $this$request_u24lambda_u240.append("-> " + name + ": " + value).append('\n');
                    }
                }
                if (this.mockRequest.getBody() != null) {
                    BodyConfig bodyConfig = this.mockRequest.getBody();
                    Intrinsics.checkNotNull((Object)bodyConfig);
                    BodyConfig body = bodyConfig;
                    $this$request_u24lambda_u240.append("BODY START: LENGTH=" + body.getJson().length() + " FORMAT=" + body.getFormat()).append('\n');
                    BodyConfig bodyConfig2 = this.mockRequest.getBody();
                    Intrinsics.checkNotNull((Object)bodyConfig2);
                    $this$request_u24lambda_u240.append(bodyConfig2).append('\n');
                    $this$request_u24lambda_u240.append("BODY END").append('\n');
                }
            }
            charSequence = charSequence.toString();
            this.log.getLogger().invoke((Object)charSequence);
        }
    }

    public final <R> void response$multiplatform_mock(R result, @NotNull KSerializer<R> serializer, @Nullable StringFormat format, long delay) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        if (this.log.getLevel() != LogLevel.NONE) {
            CharSequence charSequence;
            StringBuilder $this$response_u24lambda_u240 = charSequence = new StringBuilder();
            boolean bl = false;
            if (this.log.getLevel().getInfo()) {
                $this$response_u24lambda_u240.append("RESPONSE: " + this.getUrlString()).append('\n');
                StringBuilder stringBuilder = $this$response_u24lambda_u240;
                stringBuilder.append("DELAY TIME: " + Duration.toString-impl((long)DurationKt.toDuration((long)delay, (DurationUnit)DurationUnit.MILLISECONDS))).append('\n');
            }
            if (this.log.getLevel().getBody()) {
                Object object = format;
                if (object == null || (object = object.encodeToString((SerializationStrategy)serializer, result)) == null) {
                    object = String.valueOf(result);
                }
                StringFormat text = object;
                $this$response_u24lambda_u240.append("BODY START: LENGTH=" + text.length()).append('\n');
                $this$response_u24lambda_u240.append((String)text).append('\n');
                $this$response_u24lambda_u240.append("BODY END").append('\n');
            }
            charSequence = charSequence.toString();
            this.log.getLogger().invoke((Object)charSequence);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String formatUrl(String urlString, Map<String, ? extends Object> paths, Map<String, ? extends Object> queries) {
        Map.Entry path;
        void $this$fold$iv;
        StringBuilder stringBuilder;
        StringBuilder $this$formatUrl_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterable iterable = paths.entrySet();
        String initial$iv = urlString;
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            String acc = accumulator$iv;
            boolean bl2 = false;
            accumulator$iv = StringsKt.replace$default((String)acc, (String)("{" + path.getKey() + "}"), (String)path.getValue().toString(), (boolean)false, (int)4, null);
        }
        String url = accumulator$iv;
        $this$formatUrl_u24lambda_u240.append(url);
        Iterable $this$forEachIndexed$iv = queries.entrySet();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void query;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            path = (Map.Entry)item$iv;
            int index = n;
            boolean bl3 = false;
            $this$formatUrl_u24lambda_u240.append(index == 0 ? (char)'?' : '&');
            $this$formatUrl_u24lambda_u240.append((String)query.getKey());
            $this$formatUrl_u24lambda_u240.append('=');
            $this$formatUrl_u24lambda_u240.append(query.getValue());
        }
        return stringBuilder.toString();
    }

    private static final String urlString_delegate$lambda$0(MockLogging this$0, String $urlString) {
        return this$0.formatUrl($urlString, this$0.mockRequest.getPaths$multiplatform_mock(), this$0.mockRequest.getQueries$multiplatform_mock());
    }
}

