/*
 * Decompiled with CFR 0.152.
 */
package cn.ktorfitx.multiplatform.mock;

import cn.ktorfitx.multiplatform.mock.MockRequestBuilder;
import cn.ktorfitx.multiplatform.mock.config.LogConfig;
import io.ktor.client.plugins.logging.LogLevel;
import io.ktor.http.HttpMethod;
import java.util.Iterator;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J2\u0010\u0014\u001a\u00020\u0011\"\n\b\u0000\u0010\u0015\u0018\u0001*\u00020\u00012\u0006\u0010\u0016\u001a\u0002H\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0086\b\u00a2\u0006\u0002\u0010\u001bJ8\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u001eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Lcn/ktorfitx/multiplatform/mock/MockLogging;", "", "log", "Lcn/ktorfitx/multiplatform/mock/config/LogConfig;", "mockRequest", "Lcn/ktorfitx/multiplatform/mock/MockRequestBuilder;", "urlString", "", "<init>", "(Lcn/ktorfitx/multiplatform/mock/config/LogConfig;Lcn/ktorfitx/multiplatform/mock/MockRequestBuilder;Ljava/lang/String;)V", "getLog", "()Lcn/ktorfitx/multiplatform/mock/config/LogConfig;", "getUrlString", "()Ljava/lang/String;", "urlString$delegate", "Lkotlin/Lazy;", "request", "", "method", "Lio/ktor/http/HttpMethod;", "response", "T", "mock", "json", "Lkotlinx/serialization/json/Json;", "delay", "", "(Ljava/lang/Object;Lkotlinx/serialization/json/Json;J)V", "formatUrl", "paths", "", "queries", "multiplatform-mock"})
@SourceDebugExtension(value={"SMAP\nMockLogging.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockLogging.kt\ncn/ktorfitx/multiplatform/mock/MockLogging\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n216#2,2:94\n216#2,2:96\n216#2,2:98\n205#3:100\n488#4,11:101\n1803#5,3:112\n1878#5,3:115\n*S KotlinDebug\n*F\n+ 1 MockLogging.kt\ncn/ktorfitx/multiplatform/mock/MockLogging\n*L\n28#1:94,2\n35#1:96,2\n41#1:98,2\n67#1:100\n68#1:101,11\n82#1:112,3\n86#1:115,3\n*E\n"})
public final class MockLogging {
    @NotNull
    private final LogConfig log;
    @NotNull
    private final MockRequestBuilder mockRequest;
    @NotNull
    private final Lazy urlString$delegate;

    public MockLogging(@NotNull LogConfig log, @NotNull MockRequestBuilder mockRequest, @NotNull String urlString) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)mockRequest, (String)"mockRequest");
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        this.log = log;
        this.mockRequest = mockRequest;
        this.urlString$delegate = LazyKt.lazy(() -> MockLogging.urlString_delegate$lambda$0(this, urlString));
    }

    @NotNull
    public final LogConfig getLog() {
        return this.log;
    }

    @NotNull
    public final String getUrlString() {
        Lazy lazy = this.urlString$delegate;
        return (String)lazy.getValue();
    }

    public final void request(@NotNull HttpMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (this.log.getLevel() != LogLevel.NONE) {
            Object value;
            String name;
            Map.Entry<String, Object> entry;
            Map.Entry<String, Object> element$iv;
            Iterator<Map.Entry<String, Object>> iterator;
            boolean $i$f$forEach;
            Map<String, Object> $this$forEach$iv;
            CharSequence charSequence;
            StringBuilder $this$request_u24lambda_u244 = charSequence = new StringBuilder();
            boolean bl = false;
            if (this.log.getLevel().getInfo()) {
                $this$request_u24lambda_u244.append("REQUEST: " + this.getUrlString()).append('\n');
                $this$request_u24lambda_u244.append("METHOD: " + method.getValue()).append('\n');
            }
            if (this.log.getLevel().getHeaders() && !this.mockRequest.getHeaders().isEmpty()) {
                $this$request_u24lambda_u244.append("HEADERS: COUNT=" + this.mockRequest.getHeaders().size()).append('\n');
                $this$forEach$iv = this.mockRequest.getHeaders();
                $i$f$forEach = false;
                iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    name = entry.getKey();
                    value = entry.getValue();
                    $this$request_u24lambda_u244.append("-> " + name + ": " + value).append('\n');
                }
            }
            if (this.log.getLevel().getBody()) {
                if (!this.mockRequest.getParts().isEmpty()) {
                    $this$request_u24lambda_u244.append("FORMS: COUNT=" + this.mockRequest.getParts().size()).append('\n');
                    $this$forEach$iv = this.mockRequest.getParts();
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        entry = element$iv = iterator.next();
                        boolean bl3 = false;
                        name = entry.getKey();
                        value = entry.getValue();
                        $this$request_u24lambda_u244.append("-> " + name + ": " + value).append('\n');
                    }
                }
                if (!this.mockRequest.getFields().isEmpty()) {
                    $this$request_u24lambda_u244.append("FIELDS: COUNT=" + this.mockRequest.getFields().size()).append('\n');
                    $this$forEach$iv = this.mockRequest.getFields();
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        entry = element$iv = iterator.next();
                        boolean bl4 = false;
                        name = entry.getKey();
                        value = entry.getValue();
                        $this$request_u24lambda_u244.append("-> " + name + ": " + value).append('\n');
                    }
                }
                if (this.mockRequest.getBody() != null) {
                    String string = this.mockRequest.getBody();
                    Intrinsics.checkNotNull((Object)string);
                    $this$request_u24lambda_u244.append("BODY START: LENGTH=" + string.length()).append('\n');
                    String string2 = this.mockRequest.getBody();
                    Intrinsics.checkNotNull((Object)string2);
                    $this$request_u24lambda_u244.append(string2).append('\n');
                    $this$request_u24lambda_u244.append("BODY END").append('\n');
                }
            }
            charSequence = charSequence.toString();
            this.log.getLogger().invoke((Object)charSequence);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <T> void response(T mock, Json json, long delay) {
        Intrinsics.checkNotNullParameter(mock, (String)"mock");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        boolean $i$f$response = false;
        if (this.getLog().getLevel() != LogLevel.NONE) {
            CharSequence charSequence;
            StringBuilder $this$response_u24lambda_u246 = charSequence = new StringBuilder();
            boolean bl = false;
            if (this.getLog().getLevel().getInfo()) {
                $this$response_u24lambda_u246.append("RESPONSE: " + this.getUrlString()).append('\n');
                StringBuilder stringBuilder = $this$response_u24lambda_u246;
                stringBuilder.append("DELAY TIME: " + Duration.toString-impl((long)DurationKt.toDuration((long)delay, (DurationUnit)DurationUnit.MILLISECONDS))).append('\n');
            }
            if (this.getLog().getLevel().getBody()) {
                void $this$filterNotTo$iv$iv;
                String stringJson;
                void this_$iv;
                Json json2 = json;
                T value$iv = mock;
                boolean $i$f$encodeToString = false;
                Object object = this_$iv.getSerializersModule();
                Intrinsics.reifiedOperationMarker((int)6, (String)"T");
                MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
                String $this$filterNot$iv = stringJson = this_$iv.encodeToString((SerializationStrategy)SerializersKt.serializer((SerializersModule)object, null), value$iv);
                boolean $i$f$filterNot = false;
                object = $this$filterNot$iv;
                Appendable destination$iv$iv = new StringBuilder();
                boolean $i$f$filterNotTo = false;
                for (int i = 0; i < $this$filterNotTo$iv$iv.length(); ++i) {
                    char element$iv$iv;
                    char it = element$iv$iv = $this$filterNotTo$iv$iv.charAt(i);
                    boolean bl2 = false;
                    if (it == ' ' || it == '\n') continue;
                    destination$iv$iv.append(element$iv$iv);
                }
                int length = ((StringBuilder)destination$iv$iv).toString().length();
                $this$response_u24lambda_u246.append("BODY START: LENGTH=" + length).append('\n');
                $this$response_u24lambda_u246.append(stringJson).append('\n');
                $this$response_u24lambda_u246.append("BODY END").append('\n');
            }
            charSequence = charSequence.toString();
            this.getLog().getLogger().invoke((Object)charSequence);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String formatUrl(String urlString, Map<String, ? extends Object> paths, Map<String, ? extends Object> queries) {
        Map.Entry path;
        void $this$fold$iv;
        StringBuilder stringBuilder;
        StringBuilder $this$formatUrl_u24lambda_u249 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterable iterable = paths.entrySet();
        String initial$iv = urlString;
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            String acc = accumulator$iv;
            boolean bl2 = false;
            accumulator$iv = StringsKt.replace$default((String)acc, (String)("{" + path.getKey() + "}"), (String)path.getValue().toString(), (boolean)false, (int)4, null);
        }
        String url = accumulator$iv;
        $this$formatUrl_u24lambda_u249.append(url);
        Iterable $this$forEachIndexed$iv = queries.entrySet();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void query;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            path = (Map.Entry)item$iv;
            int index = n;
            boolean bl3 = false;
            $this$formatUrl_u24lambda_u249.append(index == 0 ? (char)'?' : '&');
            $this$formatUrl_u24lambda_u249.append((String)query.getKey());
            $this$formatUrl_u24lambda_u249.append('=');
            $this$formatUrl_u24lambda_u249.append(query.getValue());
        }
        return stringBuilder.toString();
    }

    private static final String urlString_delegate$lambda$0(MockLogging this$0, String $urlString) {
        return this$0.formatUrl($urlString, this$0.mockRequest.getPaths(), this$0.mockRequest.getQueries());
    }
}

