/*
 * Decompiled with CFR 0.152.
 */
package cn.ktorfitx.common.ksp.util.resolver;

import cn.ktorfitx.common.ksp.util.constants.TypeNames;
import cn.ktorfitx.common.ksp.util.expends.KSPSymbolExpendsKt;
import cn.ktorfitx.common.ksp.util.resolver.ResolversKt;
import com.google.devtools.ksp.UtilsKt;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSDeclaration;
import com.google.devtools.ksp.symbol.KSTypeReference;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.ksp.KsClassDeclarationsKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0004\u001a\u00020\u0003*\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a\f\u0010\b\u001a\u00020\u0003*\u00020\tH\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"serializableCache", "", "", "", "isSerializableType", "Lcom/squareup/kotlinpoet/TypeName;", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "hasKotlinxSerializer", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "common-ksp-util"})
@SourceDebugExtension(value={"SMAP\nSerializableTypeResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SerializableTypeResolver.kt\ncn/ktorfitx/common/ksp/util/resolver/SerializableTypeResolverKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,65:1\n1#2:66\n1869#3,2:67\n1321#4,2:69\n*S KotlinDebug\n*F\n+ 1 SerializableTypeResolver.kt\ncn/ktorfitx/common/ksp/util/resolver/SerializableTypeResolverKt\n*L\n47#1:67,2\n60#1:69,2\n*E\n"})
public final class SerializableTypeResolverKt {
    @NotNull
    private static final Map<String, Boolean> serializableCache = new LinkedHashMap();

    public static final boolean isSerializableType(@NotNull TypeName $this$isSerializableType, @NotNull Resolver resolver) {
        ClassName className;
        Intrinsics.checkNotNullParameter((Object)$this$isSerializableType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        TypeName typeName = $this$isSerializableType;
        if (typeName instanceof ClassName) {
            className = (ClassName)$this$isSerializableType;
        } else if (typeName instanceof ParameterizedTypeName) {
            className = ((ParameterizedTypeName)$this$isSerializableType).getRawType();
        } else {
            return false;
        }
        ClassName className2 = className;
        String canonicalName = className2.getCanonicalName();
        Boolean bl = serializableCache.get(canonicalName);
        if (bl != null) {
            boolean it = bl;
            boolean bl2 = false;
            return it;
        }
        KSClassDeclaration kSClassDeclaration = UtilsKt.getClassDeclarationByName((Resolver)resolver, (String)canonicalName);
        if (kSClassDeclaration == null) {
            TypeName it = $this$isSerializableType;
            boolean bl3 = false;
            serializableCache.put(canonicalName, false);
            return false;
        }
        KSClassDeclaration declaration = kSClassDeclaration;
        boolean hasSerializable = KSPSymbolExpendsKt.hasAnnotation((KSAnnotated)declaration, TypeNames.INSTANCE.getSerializable());
        if (hasSerializable) {
            serializableCache.put(canonicalName, true);
            return true;
        }
        boolean hasSerializer = SerializableTypeResolverKt.hasKotlinxSerializer(declaration);
        if (!hasSerializer) {
            serializableCache.put(canonicalName, false);
            return false;
        }
        if (!($this$isSerializableType instanceof ParameterizedTypeName)) {
            serializableCache.put(canonicalName, true);
            return true;
        }
        Iterable $this$forEach$iv = ((ParameterizedTypeName)$this$isSerializableType).getTypeArguments();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TypeName it = (TypeName)element$iv;
            boolean bl4 = false;
            if (SerializableTypeResolverKt.isSerializableType(it, resolver)) continue;
            return false;
        }
        serializableCache.put(canonicalName, true);
        return true;
    }

    public static /* synthetic */ boolean isSerializableType$default(TypeName typeName, Resolver resolver, int n, Object object) {
        if ((n & 1) != 0) {
            resolver = ResolversKt.getSafeResolver();
        }
        return SerializableTypeResolverKt.isSerializableType(typeName, resolver);
    }

    private static final boolean hasKotlinxSerializer(KSClassDeclaration $this$hasKotlinxSerializer) {
        ClassName className = KsClassDeclarationsKt.toClassName((KSClassDeclaration)$this$hasKotlinxSerializer);
        if (TypeNames.INSTANCE.getKotlinxSerializerTypeNames().contains(className)) {
            return true;
        }
        Sequence $this$forEach$iv = $this$hasKotlinxSerializer.getSuperTypes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KSClassDeclaration declaration;
            KSTypeReference it = (KSTypeReference)element$iv;
            boolean bl = false;
            KSDeclaration kSDeclaration = it.resolve().getDeclaration();
            KSClassDeclaration kSClassDeclaration = kSDeclaration instanceof KSClassDeclaration ? (KSClassDeclaration)kSDeclaration : null;
            if (kSClassDeclaration == null || !SerializableTypeResolverKt.hasKotlinxSerializer(declaration = kSClassDeclaration)) continue;
            return true;
        }
        return false;
    }
}

