package cn.klaw.job.core.biz.client;

import cn.klaw.job.core.biz.AdminBiz;
import cn.klaw.job.core.biz.model.HandleCallbackParam;
import cn.klaw.job.core.biz.model.RegistryHandlerName;
import cn.klaw.job.core.biz.model.RegistryParam;
import cn.klaw.job.core.biz.model.ReturnT;
import cn.klaw.job.core.handler.IJobHandler;
import cn.klaw.job.core.util.XxlJobRemotingUtil;

import java.util.List;
import java.util.concurrent.ConcurrentMap;

/**
 * admin api test
 *
 *  2017-07-28 22:14:52
 */
public class AdminBizClient implements AdminBiz {

    public AdminBizClient() {
    }
    public AdminBizClient(String addressUrl, String accessToken) {
        this.addressUrl = addressUrl;
        this.accessToken = accessToken;

        // valid
        if (!this.addressUrl.endsWith("/")) {
            this.addressUrl = this.addressUrl + "/";
        }
    }

    private String addressUrl ;
    private String accessToken;
    private int timeout = 3;


    @Override
    public ReturnT<String> callback(List<HandleCallbackParam> callbackParamList) {
        return XxlJobRemotingUtil.postBody(addressUrl+"api/callback", accessToken, timeout, callbackParamList, String.class);
    }

    @Override
    public ReturnT<String> registry(RegistryParam registryParam) {
        return XxlJobRemotingUtil.postBody(addressUrl + "api/registry", accessToken, timeout, registryParam, String.class);
    }

    @Override
    public ReturnT<String> registryRemove(RegistryParam registryParam) {
        return XxlJobRemotingUtil.postBody(addressUrl + "api/registryRemove", accessToken, timeout, registryParam, String.class);
    }

    @Override
    public ReturnT<String> registryHandlerName(RegistryHandlerName registryHandlerName) {
        Thread thread = new Thread(() -> {
            ReturnT returnT = XxlJobRemotingUtil.postBody(addressUrl + "api/" + registryHandlerName.getUri() + "/handlerName", accessToken, timeout, registryHandlerName, String.class);
            if (ReturnT.FAIL_CODE == returnT.getCode()) {
                try {
                    Thread.sleep(3000);
                } catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                registryHandlerName(registryHandlerName);
            }
        });
        thread.start();
        return null;
    }

}
