/*
 * Decompiled with CFR 0.152.
 */
package cn.klaw;

import cn.hutool.core.util.RandomUtil;
import cn.klaw.MySpringWebMvcProvider;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.Collections;
import java.util.HashMap;
import org.springdoc.core.customizers.GlobalOpenApiCustomizer;
import org.springdoc.core.models.GroupedOpenApi;
import org.springdoc.webmvc.core.providers.SpringWebMvcProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class SwaggerConfig
implements WebMvcConfigurer {
    @Value(value="${spring.application.name:}")
    private String name;
    @Value(value="${config.SoftVersion:}")
    private String version;

    @Bean
    public OpenAPI openAPI() {
        OpenAPI openAPI = new OpenAPI();
        openAPI.info(this.apiInfo());
        openAPI.schemaRequirement("Authorization", this.security());
        return openAPI;
    }

    @Bean
    public GlobalOpenApiCustomizer orderGlobalOpenApiCustomizer() {
        return openApi -> {
            if (openApi.getTags() != null) {
                openApi.getTags().forEach(tag -> {
                    HashMap<String, Integer> map = new HashMap<String, Integer>();
                    map.put("x-order", RandomUtil.randomInt((int)0, (int)100));
                    tag.setExtensions(map);
                });
            }
            if (openApi.getPaths() != null) {
                openApi.addExtension("x-test123", (Object)"333");
                openApi.getPaths().addExtension("x-abb", (Object)RandomUtil.randomInt((int)1, (int)100));
            }
        };
    }

    @Bean
    public GroupedOpenApi userApi() {
        String[] paths = new String[]{"/**"};
        return GroupedOpenApi.builder().group(this.name).pathsToMatch(paths).addOperationCustomizer((operation, handlerMethod) -> operation.security(Collections.singletonList(new SecurityRequirement().addList("Authorization")))).build();
    }

    private Info apiInfo() {
        return new Info().title("\u63a5\u53e3\u6587\u6863").description("klaw\u63a5\u53e3\u6587\u6863").version(this.version);
    }

    private SecurityScheme security() {
        SecurityScheme securityScheme = new SecurityScheme();
        securityScheme.setType(SecurityScheme.Type.APIKEY);
        securityScheme.setName("Authorization");
        securityScheme.setIn(SecurityScheme.In.HEADER);
        return securityScheme;
    }

    @Bean
    @Lazy(value=false)
    public SpringWebMvcProvider springWebProvider() {
        return new MySpringWebMvcProvider();
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"doc.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
    }
}

