/*
 * Decompiled with CFR 0.152.
 */
package cn.klaw.util.message;

import cn.klaw.util.JsonUtil;
import cn.klaw.util.ParameterUtil;
import cn.klaw.util.StringUtil;
import com.aliyun.dysmsapi20170525.Client;
import com.aliyun.dysmsapi20170525.models.QuerySmsTemplateRequest;
import com.aliyun.dysmsapi20170525.models.QuerySmsTemplateResponse;
import com.aliyun.dysmsapi20170525.models.SendSmsRequest;
import com.aliyun.dysmsapi20170525.models.SendSmsResponse;
import com.aliyun.teaopenapi.models.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsAliYunUtil {
    private static final Logger log = LoggerFactory.getLogger(SmsAliYunUtil.class);

    private static Client createClient(String accessKeyId, String accessKeySecret, String endpoint) {
        try {
            Config config = new Config().setAccessKeyId(accessKeyId).setAccessKeySecret(accessKeySecret);
            config.endpoint = endpoint;
            return new Client(config);
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u963f\u91cc\u4e91\u77ed\u4fe1\u5ba2\u6237\u7aef\u9519\u8bef\uff1a" + e.getMessage());
            return null;
        }
    }

    public static List<String> querySmsTemplateRequest(String accessKeyId, String accessKeySecret, String endpoint, String templateId) {
        try {
            Client client = SmsAliYunUtil.createClient(accessKeyId, accessKeySecret, endpoint);
            QuerySmsTemplateRequest querySmsTemplateRequest = new QuerySmsTemplateRequest().setTemplateCode(templateId);
            QuerySmsTemplateResponse querySmsTemplateResponse = client.querySmsTemplate(querySmsTemplateRequest);
            String templateContent = querySmsTemplateResponse.getBody().templateContent;
            if (StringUtil.isNotEmpty((String)templateContent)) {
                ArrayList<String> list = new ArrayList<String>();
                ParameterUtil.parse((String)"${", (String)"}", (String)templateContent, list);
                return list;
            }
            return null;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u963f\u91cc\u4e91\u77ed\u4fe1\u6a21\u677f\u9519\u8bef\uff1a" + e.getMessage());
            return null;
        }
    }

    public static String querySmsTemplateContent(String accessKeyId, String accessKeySecret, String endpoint, String templateId) {
        try {
            Client client = SmsAliYunUtil.createClient(accessKeyId, accessKeySecret, endpoint);
            QuerySmsTemplateRequest querySmsTemplateRequest = new QuerySmsTemplateRequest().setTemplateCode(templateId);
            QuerySmsTemplateResponse querySmsTemplateResponse = client.querySmsTemplate(querySmsTemplateRequest);
            String templateContent = querySmsTemplateResponse.getBody().templateContent;
            if (StringUtil.isNotEmpty((String)templateContent)) {
                return templateContent;
            }
            return null;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u963f\u91cc\u4e91\u77ed\u4fe1\u6a21\u677f\u9519\u8bef\uff1a" + e.getMessage());
            return null;
        }
    }

    public static String sentSms(String accessKeyId, String accessKeySecret, String endpoint, String phoneNumbers, String signContent, String templateId, Map<String, Object> map) {
        try {
            Client client = SmsAliYunUtil.createClient(accessKeyId, accessKeySecret, endpoint);
            SendSmsRequest sendSmsRequest = new SendSmsRequest();
            sendSmsRequest.setPhoneNumbers(phoneNumbers);
            sendSmsRequest.setSignName(signContent);
            sendSmsRequest.setTemplateCode(templateId);
            sendSmsRequest.setTemplateParam(JsonUtil.getObjectToString(map));
            SendSmsResponse sendSmsResponse = client.sendSms(sendSmsRequest);
            if (!"Ok".equalsIgnoreCase(sendSmsResponse.body.code)) {
                log.error("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff1a" + sendSmsResponse.getBody().message);
                return "\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff1a" + sendSmsResponse.getBody().message;
            }
            return "Ok";
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff1a" + e.getMessage());
            return "\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff1a" + e.getMessage();
        }
    }
}

