/*
 * Decompiled with CFR 0.152.
 */
package cn.kingyen.singleflight.core;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class SingleFlight<K, V> {
    private final Map<K, Call<V>> inFlight = new ConcurrentHashMap<K, Call<V>>();

    public V doOnce(K key, Supplier<V> fn) {
        try {
            return this.doOnceFuture(key, fn).join();
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException("Error executing operation", e.getCause());
            }
            throw new RuntimeException("Error executing operation", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<V> doOnceFuture(K key, Supplier<V> fn) {
        Call<V> existingCall = this.inFlight.get(key);
        if (existingCall != null) {
            return existingCall.future;
        }
        Call call = new Call();
        Call previousCall = this.inFlight.putIfAbsent(key, call);
        if (previousCall != null) {
            return previousCall.future;
        }
        try {
            V result = fn.get();
            call.future.complete(result);
        }
        catch (Throwable e) {
            call.future.completeExceptionally(e);
        }
        finally {
            this.inFlight.remove(key, call);
        }
        return call.future;
    }

    public boolean forget(K key) {
        Call<V> call = this.inFlight.remove(key);
        if (call != null && !call.future.isDone()) {
            call.future.completeExceptionally(new RuntimeException("Operation cancelled"));
            return true;
        }
        return false;
    }

    public int pendingCount() {
        return this.inFlight.size();
    }

    private static class Call<V> {
        final CompletableFuture<V> future = new CompletableFuture();

        private Call() {
        }
    }
}

