package cn.kicent.framework.logger.support;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.kicent.framework.base.util.KicentPool;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.MDC;
import org.springframework.web.filter.OncePerRequestFilter;

import java.io.IOException;

/**
 * 追踪 ID 过滤器
 *
 * @author yang.lu
 */
@SuppressWarnings("NullableProblems")
public class TraceIdFilter extends OncePerRequestFilter {

	@Override
	protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain)
		throws ServletException, IOException {

		try {
			String traceId = request.getHeader(KicentPool.KT_TRACE_ID);
			if (StrUtil.isBlank(traceId)) {
				traceId = IdUtil.nanoId();
			}

			MDC.put(KicentPool.KT_TRACE_ID, traceId);

			filterChain.doFilter(request, response);
		} finally {
			MDC.clear();
		}
	}
}
