package cn.kicent.framework.logger.config;

import cn.kicent.framework.logger.support.TraceIdFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Logger 日志配置
 *
 * @author yang.lu
 */
@Configuration(proxyBeanMethods = false)
public class LoggerConfiguration {

	private static final Logger logger = LoggerFactory.getLogger(LoggerConfiguration.class);

	/**
	 * 注入追踪 ID 过滤器
	 *
	 * @return TraceIdFilter 追踪 ID 过滤器
	 * @author yang.lu
	 */
	@Bean
	public TraceIdFilter traceIdFilter() {
		TraceIdFilter traceIdFilter = new TraceIdFilter();
		logger.info("[kicent] |- Bean [Logger-TraceIdFilter] Auto Configure.");
		return traceIdFilter;
	}
}
