package cn.kicent.framework.base.validation;

import jakarta.validation.Constraint;
import jakarta.validation.Payload;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Xss 校验注解
 *
 * @author yang.lu
 */
@Retention(RetentionPolicy.RUNTIME)
@Constraint(validatedBy = {XssValidator.class})
@Target(value = {ElementType.METHOD, ElementType.FIELD, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
public @interface Xss {

	String message() default "不允许包含脚本内容";

	Class<?>[] groups() default {};

	Class<? extends Payload>[] payload() default {};
}
