package cn.kicent.framework.base.validation;

import jakarta.validation.Constraint;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * JSON 格式校验
 *
 * @author yang.lu
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Constraint(validatedBy = IsJsonValidator.class)
@Target(value = {ElementType.METHOD, ElementType.FIELD, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
public @interface IsJson {

	/**
	 * 提示消息
	 */
	String message() default "Invalid Json format";

	/**
	 * 是否允许为空 true允许
	 */
	boolean allowEmpty() default false;
}
