package cn.kicent.framework.base.util.ability;

/**
 * 基础能力抽象
 *
 * @author yang.lu
 */
public abstract class BaseAbility<T, R> {

	public R executeAbility(T model) {
		try {
			// 初始化上下文
			AbilityContext.init();
			// 进行前置校验
			validate(model);
			// 执行业务逻辑
			return execute(model);
		} finally {
			AbilityContext.clear();
		}
	}

	/**
	 * 校验数据
	 *
	 * @param model 数据模型
	 * @author yang.lu
	 */
	public abstract void validate(T model);

	/**
	 * 业务处理
	 *
	 * @param model 数据模型
	 * @return R 处理结果
	 * @author yang.lu
	 */
	public abstract R execute(T model);
}
