package cn.kicent.framework.base.exception;

import cn.hutool.core.util.StrUtil;
import cn.kicent.framework.base.enums.IBaseEnum;
import cn.kicent.framework.base.enums.ResultEnum;
import lombok.Getter;
import lombok.Setter;

/**
 * 业务异常
 *
 * @author yang.lu
 */
@Getter
@Setter
public class BusinessException extends RuntimeException {

	private String code;
	private String message;
	private Object data;
	private boolean printStackTrace;

	public BusinessException(String message) {
		this.code = ResultEnum.INTERNAL_SERVER_ERROR.getCode();
		this.message = message;
	}

	public BusinessException(String code, String message) {
		this.code = code;
		this.message = message;
	}

	public BusinessException(String code, String message, Object data) {
		this.code = code;
		this.message = message;
		this.data = data;
	}

	public BusinessException(IBaseEnum<?> baseEnum) {
		this.code = StrUtil.toStringOrNull(baseEnum.getCode());
		this.message = baseEnum.getDesc();
	}

	public BusinessException(IBaseEnum<?> baseEnum, Object data) {
		this.code = StrUtil.toStringOrNull(baseEnum.getCode());
		this.message = baseEnum.getDesc();
		this.data = data;
	}

	public BusinessException(IBaseEnum<?> baseEnum, String message, Object data) {
		this.code = StrUtil.toStringOrNull(baseEnum.getCode());
		this.message = message;
		this.data = data;
	}
}
