package cn.kicent.framework.base.enums;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 通用响应码
 *
 * @author yang.lu
 */
@Getter
@AllArgsConstructor(access = AccessLevel.PRIVATE)
public enum ResultEnum implements IBaseEnum<String> {

	SUCCESS("0", "操作成功"),

	// 客户端错误 (4xx)

	/** 请求参数有误时使用 */
	BAD_REQUEST("400", "请求参数错误"),
	/** 用户未登录或凭证已过期时返回 */
	UNAUTHORIZED("401", "未登录或登录超时"),
	/** 用户无权限访问资源时返回 */
	FORBIDDEN("403", "权限不足或请求被拒绝"),
	/** 请求的资源不存在或URL错误时返回 */
	NOT_FOUND("404", "资源不存在"),
	/** 请求方法与资源不匹配时使用，如GET/POST错误 */
	METHOD_NOT_ALLOWED("405", "请求方法不允许"),
	/** 客户端请求超时未响应时返回 */
	REQUEST_TIMEOUT("408", "请求超时"),
	/** 资源状态冲突（如数据重复）时返回 */
	CONFLICT("409", "资源冲突"),
	/** 资源已被永久删除时返回 */
	GONE("410", "资源已被删除"),
	/** 请求头中未定义Content-Length字段时返回 */
	LENGTH_REQUIRED("411", "缺少请求长度"),
	/** 请求头中的前提条件未满足时使用 */
	PRECONDITION_FAILED("412", "前置条件失败"),
	/** 请求体大小超过服务器允许的限制时返回 */
	PAYLOAD_TOO_LARGE("413", "请求体过大"),
	/** 请求中发送的媒体格式不被服务器支持时使用 */
	UNSUPPORTED_MEDIA_TYPE("415", "不支持的媒体类型"),
	/** 请求格式正确，但由于逻辑错误无法处理时返回 */
	UNPROCESSABLE_ENTITY("422", "请求无法处理"),
	/** 资源当前被锁定，暂时无法操作时返回 */
	LOCKED("423", "资源被锁定"),
	/** 客户端发送的请求过于频繁，需限流时返回 */
	TOO_MANY_REQUESTS("429", "请求过多"),
	/** 客户端需要升级协议才能继续请求时使用 */
	UPGRADE_REQUIRED("426", "需要升级协议"),
	/** 客户端在服务器响应前主动关闭连接时使用 */
	CLIENT_CLOSED_REQUEST("499", "客户端关闭请求"),

	// 服务器端错误 (5xx)

	/** 服务器内部出现异常时返回 */
	INTERNAL_SERVER_ERROR("500", "服务器内部错误"),
	/** 服务器不支持请求的功能时使用 */
	NOT_IMPLEMENTED("501", "尚未实现"),
	/** 服务器作为网关或代理时收到无效响应时返回 */
	BAD_GATEWAY("502", "网关错误"),
	/** 服务器暂时不可用（维护或过载）时使用 */
	SERVICE_UNAVAILABLE("503", "服务不可用"),
	/** 服务器作为网关或代理时未及时从上游服务器获取响应时返回 */
	GATEWAY_TIMEOUT("504", "网关超时"),
	/** 服务器不支持请求使用的HTTP协议版本时返回 */
	HTTP_VERSION_NOT_SUPPORTED("505", "不支持的HTTP版本"),
	/** 服务器无法存储请求所需的内容时返回 */
	INSUFFICIENT_STORAGE("507", "服务器存储不足");

	private final String code;
	private final String desc;
}
