package cn.kicent.framework.base.enums;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 国家二字码
 *
 * @author yang.lu
 */
@Getter
@AllArgsConstructor(access = AccessLevel.PRIVATE)
public enum CountryCodeEnum implements IBaseEnum<String> {

	IRELAND("IE", "爱尔兰"),
	EGYPT("EG", "埃及"),
	ETHIOPIA("ET", "埃塞俄比亚"),
	ESTONIA("EE", "爱沙尼亚"),
	ANDORRA("AD", "安道尔"),
	ANGOLA("AO", "安哥拉"),
	ANGUILLA("AI", "安圭拉"),
	ANTIGUA_AND_BARBUDA("AG", "安提瓜和巴布达"),
	AUSTRALIA("AU", "澳大利亚"),
	AUSTRIA("AT", "奥地利"),
	ALAND_ISLANDS("AX", "奥兰群岛"),
	ALBANIA("AL", "阿尔巴尼亚"),
	ALGERIA("DZ", "阿尔及利亚"),
	AFGHANISTAN("AF", "阿富汗"),
	ARGENTINA("AR", "阿根廷"),
	UAE("AE", "阿拉伯联合酋长国"),
	ARUBA("AW", "阿鲁巴"),
	OMAN("OM", "阿曼"),
	AZERBAIJAN("AZ", "阿塞拜疆"),
	BELARUS("BY", "白俄罗斯"),
	BERMUDA("BM", "百慕大"),
	BULGARIA("BG", "保加利亚"),
	BARBADOS("BB", "巴巴多斯"),
	PAPUA_NEW_GUINEA("PG", "巴布亚新几内亚"),
	BAHAMAS("BS", "巴哈马"),
	PAKISTAN("PK", "巴基斯坦"),
	PARAGUAY("PY", "巴拉圭"),
	PALESTINE("PS", "巴勒斯坦领土"),
	BAHRAIN("BH", "巴林"),
	PANAMA("PA", "巴拿马"),
	BRAZIL("BR", "巴西"),
	NORTHERN_MARIANA_ISLANDS("MP", "北马里亚纳群岛"),
	BENIN("BJ", "贝宁"),
	ICELAND("IS", "冰岛"),
	BELGIUM("BE", "比利时"),
	BOTSWANA("BW", "博茨瓦纳"),
	PUERTO_RICO("PR", "波多黎各"),
	POLAND("PL", "波兰"),
	BOLIVIA("BO", "玻利维亚"),
	BELIZE("BZ", "伯利兹"),
	BOSNIA_AND_HERZEGOVINA("BA", "波斯尼亚和黑塞哥维那"),
	BHUTAN("BT", "不丹"),
	BURKINA_FASO("BF", "布基纳法索"),
	BURUNDI("BI", "布隆迪"),
	PERU("PE", "秘鲁"),
	EQUATORIAL_GUINEA("GQ", "赤道几内亚"),
	NORTH_KOREA("KP", "朝鲜"),
	DENMARK("DK", "丹麦"),
	GERMANY("DE", "德国"),
	DIEGO_GARCIA("DG", "迭戈·加西亚"),
	EAST_TIMOR("TL", "东帝汶"),
	TOGO("TG", "多哥"),
	DOMINICAN_REPUBLIC("DO", "多米尼加共和国"),
	DOMINICA("DM", "多米尼克"),
	ECUADOR("EC", "厄瓜多尔"),
	ERITREA("ER", "厄立特里亚"),
	RUSSIA("RU", "俄罗斯"),
	VATICAN("VA", "梵蒂冈"),
	FRANCE("FR", "法国"),
	FAROE_ISLANDS("FO", "法罗群岛"),
	FRENCH_POLYNESIA("PF", "法属波利尼西亚"),
	FRENCH_GUIANA("GF", "法属圭亚那"),
	FIJI("FJ", "斐济"),
	PHILIPPINES("PH", "菲律宾"),
	FINLAND("FI", "芬兰"),
	CAPE_VERDE("CV", "佛得角"),
	FALKLAND_ISLANDS("FK", "福克兰群岛"),
	GAMBIA("GM", "冈比亚"),
	CONGO_BRAZZAVILLE("CG", "刚果（布）"),
	CONGO_KINSHASA("CD", "刚果（金）"),
	GUERNSEY("GG", "格恩西岛"),
	GREENLAND("GL", "格陵兰"),
	GRENADA("GD", "格林纳达"),
	COLOMBIA("CO", "哥伦比亚"),
	GEORGIA("GE", "格鲁吉亚"),
	COSTA_RICA("CR", "哥斯达黎加"),
	GUAM("GU", "关岛"),
	GUADELOUPE("GP", "瓜德罗普"),
	GUYANA("GY", "圭亚那"),
	CUBA("CU", "古巴"),
	HAITI("HT", "海地"),
	SOUTH_KOREA("KR", "韩国"),
	KAZAKHSTAN("KZ", "哈萨克斯坦"),
	MONTENEGRO("ME", "黑山"),
	NETHERLANDS("NL", "荷兰"),
	BONAIRE_SINT_EUSTATIUS_AND_SABA("BQ", "荷属加勒比区"),
	HONDURAS("HN", "洪都拉斯"),
	CAMBODIA("KH", "柬埔寨"),
	GHANA("GH", "加纳"),
	CANADA("CA", "加拿大"),
	GABON("GA", "加蓬"),
	CZECH_REPUBLIC("CZ", "捷克"),
	ZIMBABWE("ZW", "津巴布韦"),
	DJIBOUTI("DJ", "吉布提"),
	KYRGYZSTAN("KG", "吉尔吉斯斯坦"),
	KIRIBATI("KI", "基里巴斯"),
	GUINEA("GN", "几内亚"),
	GUINEA_BISSAU("GW", "几内亚比绍"),
	CAYMAN_ISLANDS("KY", "开曼群岛"),
	CAMEROON("CM", "喀麦隆"),
	KENYA("KE", "肯尼亚"),
	COCOS_ISLANDS("CC", "科科斯（基林）群岛"),
	CROATIA("HR", "克罗地亚"),
	COMOROS("KM", "科摩罗"),
	IVORY_COAST("CI", "科特迪瓦"),
	KUWAIT("KW", "科威特"),
	COOK_ISLANDS("CK", "库克群岛"),
	CURACAO("CW", "库拉索"),
	QATAR("QA", "卡塔尔"),
	LESOTHO("LS", "莱索托"),
	LAOS("LA", "老挝"),
	LATVIA("LV", "拉脱维亚"),
	LIECHTENSTEIN("LI", "列支敦士登"),
	REUNION("RE", "留尼汪"),
	LEBANON("LB", "黎巴嫩"),
	LIBERIA("LR", "利比里亚"),
	LIBYA("LY", "利比亚"),
	LITHUANIA("LT", "立陶宛"),
	ROMANIA("RO", "罗马尼亚"),
	LUXEMBOURG("LU", "卢森堡"),
	RWANDA("RW", "卢旺达"),
	MAURITIUS("MU", "毛里求斯"),
	MAURITANIA("MR", "毛里塔尼亚"),
	MADAGASCAR("MG", "马达加斯加"),
	ISLE_OF_MAN("IM", "马恩岛"),
	MALDIVES("MV", "马尔代夫"),
	MALTA("MT", "马耳他"),
	MALAYSIA("MY", "马来西亚"),
	MALAWI("MW", "马拉维"),
	MALI("ML", "马里"),
	NORTH_MACEDONIA("MK", "马其顿"),
	MARSHALL_ISLANDS("MH", "马绍尔群岛"),
	MARTINIQUE("MQ", "马提尼克"),
	MAYOTTE("YT", "马约特"),
	UNITED_STATES("US", "美国"),
	AMERICAN_SAMOA("AS", "美属萨摩亚"),
	US_VIRGIN_ISLANDS("VI", "美属维尔京群岛"),
	MONGOLIA("MN", "蒙古"),
	BANGLADESH("BD", "孟加拉国"),
	MONTSERRAT("MS", "蒙特塞拉特"),
	MYANMAR("MM", "缅甸"),
	MICRONESIA("FM", "密克罗尼西亚"),
	MOLDOVA("MD", "摩尔多瓦"),
	MOROCCO("MA", "摩洛哥"),
	MONACO("MC", "摩纳哥"),
	MOZAMBIQUE("MZ", "莫桑比克"),
	MEXICO("MX", "墨西哥"),
	SOUTH_AFRICA("ZA", "南非"),
	SOUTH_SUDAN("SS", "南苏丹"),
	NAURU("NR", "瑙鲁"),
	NAMIBIA("NA", "纳米比亚"),
	NIUE("NU", "纽埃"),
	NEPAL("NP", "尼泊尔"),
	NICARAGUA("NI", "尼加拉瓜"),
	NIGER("NE", "尼日尔"),
	NIGERIA("NG", "尼日利亚"),
	NORFOLK_ISLAND("NF", "诺福克岛"),
	NORWAY("NO", "挪威"),
	PALAU("PW", "帕劳"),
	PITCAIRN_ISLANDS("PN", "皮特凯恩群岛"),
	PORTUGAL("PT", "葡萄牙"),
	JAPAN("JP", "日本"),
	SWEDEN("SE", "瑞典"),
	SWITZERLAND("CH", "瑞士"),
	SERBIA("RS", "塞尔维亚"),
	SIERRA_LEONE("SL", "塞拉利昂"),
	SENEGAL("SN", "塞内加尔"),
	CYPRUS("CY", "塞浦路斯"),
	SEYCHELLES("SC", "塞舌尔"),
	EL_SALVADOR("SV", "萨尔瓦多"),
	SAMOA("WS", "萨摩亚"),
	SAUDI_ARABIA("SA", "沙特阿拉伯"),
	SAINT_BARTHELEMY("BL", "圣巴泰勒米"),
	CHRISTMAS_ISLAND("CX", "圣诞岛"),
	SAO_TOME_AND_PRINCIPE("ST", "圣多美和普林西比"),
	SAINT_KITTS_AND_NEVIS("KN", "圣基茨和尼维斯"),
	SAINT_LUCIA("LC", "圣卢西亚"),
	SAINT_MARTIN("MF", "圣马丁岛"),
	SAN_MARINO("SM", "圣马力诺"),
	SAINT_PIERRE_AND_MIQUELON("PM", "圣皮埃尔和密克隆群岛"),
	SAINT_VINCENT_AND_THE_GRENADINES("VC", "圣文森特和格林纳丁斯"),
	SRI_LANKA("LK", "斯里兰卡"),
	SLOVAKIA("SK", "斯洛伐克"),
	SLOVENIA("SI", "斯洛文尼亚"),
	SWAZILAND("SZ", "斯威士兰"),
	SOLOMON_ISLANDS("SB", "所罗门群岛"),
	SOMALIA("SO", "索马里"),
	SUDAN("SD", "苏丹"),
	SURINAME("SR", "苏里南"),
	THAILAND("TH", "泰国"),
	TONGA("TO", "汤加"),
	TANZANIA("TZ", "坦桑尼亚"),
	TAJIKISTAN("TJ", "塔吉克斯坦"),
	TURKS_AND_CAICOS_ISLANDS("TC", "特克斯和凯科斯群岛"),
	TRINIDAD_AND_TOBAGO("TT", "特立尼达和多巴哥"),
	TOKELAU("TK", "托克劳"),
	TURKEY("TR", "土耳其"),
	TURKMENISTAN("TM", "土库曼斯坦"),
	TUNISIA("TN", "突尼斯"),
	TUVALU("TV", "图瓦卢"),
	VANUATU("VU", "瓦努阿图"),
	GUATEMALA("GT", "危地马拉"),
	VENEZUELA("VE", "委内瑞拉"),
	BRUNEI("BN", "文莱"),
	UGANDA("UG", "乌干达"),
	UKRAINE("UA", "乌克兰"),
	URUGUAY("UY", "乌拉圭"),
	UZBEKISTAN("UZ", "乌兹别克斯坦"),
	SINGAPORE("SG", "新加坡"),
	NEW_CALEDONIA("NC", "新喀里多尼亚"),
	NEW_ZEALAND("NZ", "新西兰"),
	HUNGARY("HU", "匈牙利"),
	SPAIN("ES", "西班牙"),
	GREECE("GR", "希腊"),
	SYRIA("SY", "叙利亚"),
	JAMAICA("JM", "牙买加"),
	ARMENIA("AM", "亚美尼亚"),
	YEMEN("YE", "也门"),
	UNITED_KINGDOM("GB", "英国"),
	BRITISH_VIRGIN_ISLANDS("VG", "英属维尔京群岛"),
	BRITISH_INDIAN_OCEAN_TERRITORY("IO", "英属印度洋领地"),
	INDIA("IN", "印度"),
	INDONESIA("ID", "印度尼西亚"),
	ITALY("IT", "意大利"),
	IRAN("IR", "伊朗"),
	IRAQ("IQ", "伊拉克"),
	ISRAEL("IL", "以色列"),
	JORDAN("JO", "约旦"),
	VIETNAM("VN", "越南"),
	ZAMBIA("ZM", "赞比亚"),
	JERSEY("JE", "泽西岛"),
	CHAD("TD", "乍得"),
	GIBRALTAR("GI", "直布罗陀"),
	CHILE("CL", "智利"),
	CENTRAL_AFRICAN_REPUBLIC("CF", "中非共和国"),
	CHINA("CN", "中国"),
	CHINA_HONG_KONG("HK", "中国香港"),
	CHINA_MACAU("MO", "中国澳门"),
	CHINA_TAIWAN("TW", "中国台湾");

	private final String code;
	private final String desc;
}
