/*
 * Decompiled with CFR 0.152.
 */
package cn.kevinwang.rpc.util;

import com.dyuproject.protostuff.LinkedBuffer;
import com.dyuproject.protostuff.ProtostuffIOUtil;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.runtime.RuntimeSchema;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;

public class SerializationUtil {
    private static Map<Class<?>, Schema<?>> schemaCache = new ConcurrentHashMap();
    private static Objenesis objenesis = new ObjenesisStd();

    private SerializationUtil() {
    }

    public static <T> byte[] serialize(T obj) {
        Class<?> cls = obj.getClass();
        LinkedBuffer allocate = LinkedBuffer.allocate((int)512);
        try {
            Schema schema = SerializationUtil.getSchema(cls);
            byte[] byArray = ProtostuffIOUtil.toByteArray(obj, (Schema)schema, (LinkedBuffer)allocate);
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            allocate.clear();
        }
    }

    public static <T> T deserialize(byte[] data, Class<T> cls) {
        try {
            Object obj = objenesis.newInstance(cls);
            Schema schema = SerializationUtil.getSchema(cls);
            ProtostuffIOUtil.mergeFrom((byte[])data, (Object)obj, (Schema)schema);
            return (T)obj;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Schema getSchema(Class cls) {
        RuntimeSchema schema = schemaCache.get(cls);
        if (schema == null) {
            schema = RuntimeSchema.createFrom((Class)cls);
            schemaCache.put(cls, (Schema<?>)schema);
        }
        return schema;
    }
}

