/*
 * Decompiled with CFR 0.152.
 */
package cn.kevinwang.rpc.network.server;

import cn.kevinwang.rpc.network.msg.Request;
import cn.kevinwang.rpc.network.msg.Response;
import cn.kevinwang.rpc.util.ClassLoaderUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import java.lang.reflect.Method;
import org.springframework.context.ApplicationContext;

public class MyServerHandler
extends ChannelInboundHandlerAdapter {
    private final ApplicationContext context;

    public MyServerHandler(ApplicationContext context) {
        this.context = context;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        try {
            Request request = (Request)msg;
            Class type = ClassLoaderUtil.forName(request.getNozzle());
            Method method = type.getMethod(request.getMethodName(), request.getParameterTypes());
            Object objBean = this.context.getBean(request.getRef());
            Object result = method.invoke(objBean, request.getArgs());
            Response response = new Response();
            response.setChannel(request.getChannel());
            response.setResult(result);
            response.setRequestId(request.getRequestId());
            ctx.writeAndFlush((Object)response);
            ReferenceCountUtil.release((Object)msg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }
}

