/*
 * Decompiled with CFR 0.152.
 */
package cn.kevinwang.rpc.network.future;

import cn.kevinwang.rpc.network.future.WriteFuture;
import cn.kevinwang.rpc.network.msg.Response;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SyncWriteFuture
implements WriteFuture<Response> {
    private CountDownLatch latch = new CountDownLatch(1);
    private final long begin = System.currentTimeMillis();
    private long timeout;
    private Response response;
    private final String requestId;
    private boolean writeResult;
    private Throwable cause;
    private boolean isTimeout = false;

    public SyncWriteFuture(String requestId) {
        this.requestId = requestId;
    }

    public SyncWriteFuture(long timeout, String requestId) {
        this.timeout = timeout;
        this.requestId = requestId;
        this.writeResult = true;
        this.isTimeout = false;
    }

    @Override
    public Throwable cause() {
        return this.cause;
    }

    @Override
    public void setCause(Throwable cause) {
        this.cause = cause;
    }

    @Override
    public boolean isWriteSuccess() {
        return this.writeResult;
    }

    @Override
    public void setWriteResult(boolean result) {
        this.writeResult = result;
    }

    @Override
    public String requestId() {
        return this.requestId;
    }

    @Override
    public Response response() {
        return this.response;
    }

    @Override
    public void setResponse(Response response) {
        this.response = response;
        this.latch.countDown();
    }

    @Override
    public boolean isTimeout() {
        return this.isTimeout;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return true;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    public Response get() throws InterruptedException, ExecutionException {
        this.latch.await();
        return this.response;
    }

    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.latch.await(timeout, TimeUnit.MILLISECONDS)) {
            return this.response;
        }
        return null;
    }
}

