/*
 * Decompiled with CFR 0.152.
 */
package cn.kevinwang.rpc.network.future;

import cn.hutool.core.util.IdUtil;
import cn.kevinwang.rpc.network.future.SyncWriteFuture;
import cn.kevinwang.rpc.network.future.SyncWriteMap;
import cn.kevinwang.rpc.network.msg.Request;
import cn.kevinwang.rpc.network.msg.Response;
import io.netty.channel.Channel;
import java.util.concurrent.TimeoutException;

public class SyncWrite {
    public Response writeAndSync(Channel channel, Request request, long timeout) throws Exception {
        if (channel == null) {
            throw new IllegalArgumentException("channel is null");
        }
        if (request == null) {
            throw new IllegalArgumentException("request is null");
        }
        if (timeout <= 0L) {
            throw new IllegalArgumentException("timeout <= 0");
        }
        String requestId = IdUtil.fastSimpleUUID();
        request.setRequestId(requestId);
        SyncWriteFuture future = new SyncWriteFuture(requestId);
        SyncWriteMap.syncKey.put(requestId, future);
        Response response = this.doWriteAndSync(channel, request, timeout, future);
        SyncWriteMap.syncKey.remove(requestId);
        return response;
    }

    private Response doWriteAndSync(Channel channel, Request request, long timeout, SyncWriteFuture writeFuture) throws Exception {
        channel.writeAndFlush((Object)request).addListener(f -> {
            writeFuture.setWriteResult(f.isSuccess());
            writeFuture.setCause(f.cause());
            if (!f.isSuccess()) {
                SyncWriteMap.syncKey.remove(writeFuture.requestId());
            }
        });
        Response response = writeFuture.get();
        if (null == response) {
            if (writeFuture.isTimeout()) {
                throw new TimeoutException();
            }
            throw new RuntimeException(writeFuture.cause());
        }
        return response;
    }
}

