/*
 * Decompiled with CFR 0.152.
 */
package cn.kevinwang.rpc.config.spring;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class MyBeanDefinitionParser
implements BeanDefinitionParser {
    private final Logger logger = LoggerFactory.getLogger(MyBeanDefinitionParser.class);
    private final Class<?> beanClass;

    public MyBeanDefinitionParser(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        RootBeanDefinition rootBeanDefinition = new RootBeanDefinition(this.beanClass);
        rootBeanDefinition.setLazyInit(false);
        String beanName = element.getAttribute("id");
        parserContext.getRegistry().registerBeanDefinition(beanName, (BeanDefinition)rootBeanDefinition);
        for (Method method : this.beanClass.getMethods()) {
            if (this.isProperty(method, this.beanClass)) continue;
            String name = method.getName();
            String methodName = name.substring(3, 4).toLowerCase() + name.substring(4);
            String value = element.getAttribute(methodName);
            rootBeanDefinition.getPropertyValues().addPropertyValue(methodName, (Object)value);
        }
        return rootBeanDefinition;
    }

    private boolean isProperty(Method method, Class<?> beanClass) {
        Method getter;
        boolean flag;
        String name = method.getName();
        boolean bl = flag = name.length() > 3 && name.startsWith("set") && Modifier.isPublic(method.getModifiers()) && method.getParameterTypes().length == 1;
        if (!flag) {
            return false;
        }
        Class<?> parameterType = method.getParameterTypes()[0];
        try {
            getter = beanClass.getMethod("get" + name.substring(3), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        if (null == getter) {
            try {
                getter = beanClass.getMethod("is" + name.substring(3), new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        return null != getter && Modifier.isPublic(getter.getModifiers()) && parameterType.equals(getter.getReturnType());
    }
}

