/*
 * Decompiled with CFR 0.152.
 */
package cn.kevinwang.ratelimiter.aop;

import cn.kevinwang.ratelimiter.annotation.DoRateLimiter;
import cn.kevinwang.ratelimiter.value.impl.RateLimiterValue;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DoRateLimiterAop {
    @Pointcut(value="@annotation(cn.kevinwang.ratelimiter.annotation.DoRateLimiter)")
    public void pointcut() {
    }

    @Around(value="pointcut() && @annotation(doRateLimiter)")
    public Object doLimiter(ProceedingJoinPoint jp, DoRateLimiter doRateLimiter) throws Throwable {
        RateLimiterValue valueService = new RateLimiterValue();
        return valueService.access(jp, this.getMethod(jp), doRateLimiter, jp.getArgs());
    }

    private Method getMethod(ProceedingJoinPoint jp) throws NoSuchMethodException {
        Signature signature = jp.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        return jp.getTarget().getClass().getMethod(methodSignature.getName(), methodSignature.getParameterTypes());
    }
}

