/*
 * Decompiled with CFR 0.152.
 */
package com.kevinkda.core.util.util.json.impl;

import com.alibaba.fastjson.JSONObject;
import com.kevinkda.core.util.annotation.enumeration.VerifiedType;
import com.kevinkda.core.util.annotation.func.FuncVerification;
import com.kevinkda.core.util.exception.web.enumeration.EnumErrorCode;
import com.kevinkda.core.util.exception.web.impl.ErrorCodeByJsonImpl;
import com.kevinkda.core.util.util.json.JsonHelper;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;

@Service
public class JsonHelperImpl
implements JsonHelper {
    private String callback;

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/5/10 00:08", note="\u4f9d\u8d56\u524d\u7aef\u9879\u76ee\u6d4b\u8bd5")
    public String getJsonp(String jsonData) {
        return this.callback + "(" + jsonData + ")";
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/5/10 00:08", note="\u4f9d\u8d56\u524d\u7aef\u9879\u76ee\u6d4b\u8bd5")
    public String getJsonp(String callback, String jsonData) {
        return callback + "(" + jsonData + ")";
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/5/10 00:35", note="\u4f9d\u8d56\u524d\u7aef\u9879\u76ee\u6d4b\u8bd5")
    public Map<String, Object> getCallbacks(Map<String, Object> mapBody) {
        ErrorCodeByJsonImpl code = new ErrorCodeByJsonImpl();
        this.getCallback(mapBody);
        if (this.callback == null) {
            code.setErrorCode(EnumErrorCode.NULL_CALLBACK);
            return code.toMap();
        }
        code.setErrorCode(EnumErrorCode.SUCCESS);
        return code.toMap();
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/5/17 15:45")
    public String getCallback(Map<String, Object> mapBody) {
        this.callback = (String)mapBody.get("callback");
        if (this.callback == null) {
            this.callback = (String)mapBody.get("cb");
        }
        return this.callback;
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/5/10 00:35", note="\u4f9d\u8d56\u524d\u7aef\u9879\u76ee\u6d4b\u8bd5")
    public Map<String, Object> getCallbackByReq(HttpServletRequest request) {
        HashMap<String, Object> rb = new HashMap<String, Object>(2);
        String callback = request.getParameter("callback");
        if (callback == null) {
            callback = request.getParameter("cb");
        }
        if (callback == null) {
            rb.put("status", false);
            rb.put("errorCode", this.backError("Wrong callback function name"));
            return rb;
        }
        rb.put("status", true);
        rb.put("callback", callback);
        return rb;
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/5/12 01:43")
    public String getJson(Map<String, Object> data) {
        return new JSONObject(data).toJSONString();
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/5/12 02:54")
    public Map<String, Object> merge(Map<String, Object> dataA, Map<String, Object> dataB) {
        dataA.putAll(dataB);
        return dataA;
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/4/28 21:18", note="\u4f9d\u8d56\u65b9\u6cd5\u6d4b\u8bd5 loginAdmin")
    public String backResult(boolean status, Object data) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("errcode", (Object)status);
        jsonObject.put("errmsg", data);
        return jsonObject.toString();
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/4/29 13:36", note="\u4f9d\u8d56\u65b9\u6cd5\u6d4b\u8bd5 getCallback")
    public String backError(String err) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("errcode", (Object)false);
        jsonObject.put("errmsg", (Object)err);
        return jsonObject.toString();
    }
}

