/*
 * Decompiled with CFR 0.152.
 */
package com.kevinkda.core.util.util.io.file.impl;

import com.kevinkda.core.util.annotation.enumeration.VerifiedType;
import com.kevinkda.core.util.annotation.func.FuncVerification;
import com.kevinkda.core.util.util.io.file.FileHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.stereotype.Service;

@Service
public class FileHelperImpl<T>
implements FileHelper<T> {
    private String src;
    private File file;
    private OutputStream outputStream;

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 13:25")
    public boolean copy(String src, String des) {
        if (src == null || des == null) {
            return false;
        }
        File srcFile = new File(src);
        File desFile = new File(des);
        if (srcFile.isFile()) {
            return this.copyFile(srcFile, desFile);
        }
        return this.copyDir(srcFile, desFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 13:25")
    public boolean copyFile(File srcFile, File desFile) {
        if (!srcFile.exists()) {
            return false;
        }
        if (!desFile.getParentFile().exists()) {
            boolean bl = desFile.getParentFile().mkdirs();
        }
        byte[] bytes = new byte[1024];
        FileInputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = new FileInputStream(srcFile);
            outputStream = new FileOutputStream(desFile);
            int len = 0;
            while ((len = ((InputStream)inputStream).read(bytes)) != -1) {
                outputStream.write(bytes, 0, len);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 13:25")
    public boolean copyFileEarly(File srcFile, File desFile) {
        if (!srcFile.exists()) {
            return false;
        }
        if (!desFile.getParentFile().exists()) {
            boolean bl = desFile.getParentFile().mkdirs();
        }
        FileInputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = new FileInputStream(srcFile);
            outputStream = new FileOutputStream(desFile);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 13:26")
    public boolean copyDir(File srcFile, File desFile) {
        try {
            this.copyDirImpl(srcFile, desFile);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 13:27")
    private void copyDirImpl(File srcFile, File desFile) {
        if (srcFile.isDirectory()) {
            File[] results = this.file.listFiles();
            if (results != null) {
                for (File i : results) {
                    this.copyDirImpl(i, desFile);
                }
            }
        } else {
            String newFilePath = this.file.getPath().replace(srcFile.getPath() + File.separator, "");
            File newFile = new File(desFile, newFilePath);
            this.copyFile(srcFile, newFile);
        }
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 13:27")
    public boolean open(String src) {
        File file = new File(src);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try {
            this.outputStream = new FileOutputStream(file, true);
        }
        catch (FileNotFoundException e) {
            System.out.println();
        }
        return true;
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 13:28")
    public Object[] read(File file) {
        return new Object[0];
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 13:29")
    public boolean write(T items) {
        try {
            this.outputStream.write(String.valueOf(items).getBytes());
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 13:28")
    public void close() {
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    private void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }
}

