/*
 * Decompiled with CFR 0.152.
 */
package com.kevinkda.core.util.util.db.impl;

import com.kevinkda.core.util.annotation.enumeration.VerifiedType;
import com.kevinkda.core.util.annotation.func.FuncVerification;
import com.kevinkda.core.util.annotation.func.container.FuncVerificationContainer;
import com.kevinkda.core.util.util.db.Jdbc;
import com.kevinkda.core.util.util.db.abstraction.AbstractJdbc;
import com.kevinkda.core.util.util.db.util.SqlStringHelper;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JdbcImpl
extends AbstractJdbc
implements Jdbc {
    @Autowired
    private SqlStringHelper sqlStringHelper;
    private Connection connection;
    private Statement statement;
    private PreparedStatement preparedStatement;
    private CallableStatement callableStatement;
    private ResultSet resultSet;

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/4/26 16:07")
    public Connection getConnection() {
        return this.getConnection(true);
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/4/26 16:09")
    public Connection getConnection(boolean flag) {
        if (this.connection == null) {
            try {
                Class.forName(this.driver);
                this.connection = DriverManager.getConnection(this.url, this.user, this.pass);
                this.connection.setAutoCommit(flag);
            }
            catch (ClassNotFoundException | SQLException e) {
                e.printStackTrace();
            }
        }
        return this.connection;
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/4/26 16:17")
    public PreparedStatement getPreparedStatement(String sql) {
        return this.getPreparedStatement(sql, true);
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/4/26 16:17")
    public PreparedStatement getPreparedStatement(String sql, boolean flag) {
        try {
            if (this.preparedStatement == null) {
                this.getConnection(flag);
                this.preparedStatement = this.connection.prepareStatement(sql, 1004, 1007);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
        return this.preparedStatement;
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/4/26 17:12")
    public ResultSet getResultSet(String sql) {
        return this.getResultSet(sql, null);
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/4/26 17:12")
    public ResultSet getResultSet(String sql, Object[] conditionValue) {
        this.getPreparedStatement(sql);
        this.append(conditionValue);
        return this.executeQuery();
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/4/26 17:12")
    public ResultSet getResultSet(String[] strTable, String[] strColumn, String[] strConditionColumn, Object[] conditionValue) {
        StringBuilder stringBuilder = this.sqlStringHelper.appendSqlString(strTable, strColumn, strConditionColumn);
        this.getResultSet(stringBuilder.toString(), conditionValue);
        return this.executeQuery();
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/4/26 19:17", note="\u8c03\u7528\u65b9\u6cd5\u6d4b\u8bd5 getResultSet")
    public boolean append(Object[] args) {
        try {
            if (args != null && args.length > 0) {
                for (int i = 0; i < args.length; ++i) {
                    this.preparedStatement.setObject(i + 1, args[i]);
                }
            }
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/4/26 20:31")
    public List<Map<String, Object>> getResultListMap(String sql) {
        return this.getResultListMap(sql, null);
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/4/26 20:31")
    public List<Map<String, Object>> getResultListMap(String sql, Object[] conditionValue) {
        return this.getListMap(this.getResultSet(sql, conditionValue));
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/4/26 20:33")
    public List<Map<String, Object>> getResultListMap(String[] strTable, String[] strColumn, String[] strConditionColumn, Object[] conditionValue) {
        return this.getListMap(this.getResultSet(strTable, strColumn, strConditionColumn, conditionValue));
    }

    @Override
    @FuncVerification(version="1.1.0", status=VerifiedType.Pass, date="2020/4/26 20:36")
    public List<Map<String, Object>> getListMap(ResultSet resultSet) {
        int countColumn = this.getResultSetCountColumn(resultSet);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(this.getResultSetCountRow(resultSet));
        try {
            while (resultSet.next()) {
                HashMap<String, Object> temp = new HashMap<String, Object>(countColumn);
                for (int i = 1; i < countColumn + 1; ++i) {
                    String key = resultSet.getMetaData().getColumnName(i);
                    Object value = resultSet.getObject(i);
                    temp.put(key, value);
                }
                list.add(temp);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    @FuncVerification(version="1.1.0", status=VerifiedType.Pass, date="2020/4/26 20:34", note="\u8c03\u7528\u65b9\u6cd5\u6d4b\u8bd5 getListMap")
    public int getResultSetCountRow(ResultSet resultSet) {
        int count = -1;
        try {
            resultSet.last();
            count = resultSet.getRow();
            resultSet.beforeFirst();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return count;
    }

    @Override
    @FuncVerification(version="1.1.0", status=VerifiedType.Pass, date="2020/4/26 20:35", note="\u8c03\u7528\u65b9\u6cd5\u6d4b\u8bd5 getListMap")
    public int getResultSetCountColumn(ResultSet resultSet) {
        int count = -1;
        try {
            count = resultSet.getMetaData().getColumnCount();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return count;
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Pass, date="2020/4/26 19:07")
    public ResultSet executeQuery() {
        try {
            this.resultSet = this.preparedStatement.executeQuery();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.resultSet;
    }

    @Override
    @FuncVerification(version="1.1.0", status=VerifiedType.Pass, date="2020/4/26 19:12")
    public ResultSet executeQuery(String sql) {
        this.getPreparedStatement(sql);
        this.executeQuery();
        return this.resultSet;
    }

    @Override
    @FuncVerification(version="1.1.0", status=VerifiedType.Pass, date="2020/4/27 00:53")
    public int singleSql(String sql) throws SQLException {
        this.getConnection();
        this.statement = this.connection.createStatement();
        return this.statement.executeUpdate(sql);
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/4/27 00:52")
    public int singleSql(String sql, Object[] args) {
        this.getPreparedStatement(sql);
        this.append(args);
        return this.executeUpdate();
    }

    @Override
    @FuncVerification(version="1.1.0", status=VerifiedType.Unverified, date="2020/4/27 00:01")
    public int insertSingle(String strTableName, Object[] args) {
        StringBuilder stringBuilder = new StringBuilder("insert into " + strTableName + " values ");
        this.getPreparedStatement(this.sqlStringHelper.strSplicingUp(stringBuilder, args.length).toString());
        this.append(args);
        return this.executeUpdate();
    }

    @Override
    @FuncVerification(version="1.1.0", status=VerifiedType.Unverified, date="2020/4/27 00:25")
    public int updateSingle(String strTable, String[] strColumnName, Object[] args) {
        StringBuilder stringBuilder = new StringBuilder("UPDATE " + strTable + " SET ");
        for (int i = 0; i < strColumnName.length - 1; ++i) {
            stringBuilder.append(strColumnName[i]);
            stringBuilder.append("=?,");
        }
        stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
        stringBuilder.append(" WHERE ");
        stringBuilder.append(strColumnName[strColumnName.length - 1]);
        stringBuilder.append("=? AND 1=1");
        this.getPreparedStatement(stringBuilder.toString());
        this.append(args);
        return this.executeUpdate();
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/4/27 00:46")
    public int delete(String strTable, String strColumnName, String strIds) {
        String sql = "DELETE FROM " + strTable + " WHERE " + strColumnName + " IN(" + strIds + ")";
        this.getPreparedStatement(sql);
        return this.executeUpdate();
    }

    @Override
    @FuncVerificationContainer(value={@FuncVerification(version="1.0.0", status=VerifiedType.Error, date="2020/4/26 19:15", note="\u5411\u6570\u636e\u5e93\u66f4\u65b0\u65f6\u672a\u81ea\u52a8\u5173\u95ed\u6570\u636e\u5e93\u94fe\u63a5\uff0c\u6570\u636e\u590d\u73b0\u4e3aJavaWeb\u5f00\u53d1\u4e2d\uff0cServlet\u5c06\u4f1a\u6301\u4e45\u5316\u672c\u7c7b\u7684\u6570\u636e\u5e93\u94fe\u63a5"), @FuncVerification(version="1.1.0", status=VerifiedType.Pass, date="2020/5/2 11:10", note="\u672c\u6b21\u7248\u672c\u5c06\u5728\u6267\u884c\u63d0\u4ea4\u540e\u624b\u52a8\u5173\u95ed\u6570\u636e\u5e93\u94fe\u63a5")})
    public int executeUpdate() {
        int count = -1;
        try {
            count = this.preparedStatement.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return count;
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/4/27 01:06")
    public ResultSet runCallableStatement(String proc, Object[] args) {
        try {
            this.callableStatement = this.getConnection().prepareCall(proc);
            for (int i = 0; i < args.length; ++i) {
                this.callableStatement.setObject(i + 1, args[i]);
            }
            this.resultSet = this.callableStatement.executeQuery();
            return this.resultSet;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Error, date="2020/5/18 21:19")
    public CallableStatement runCallableStatement(String proc, Object[] args, Object[] outArgs) {
        try {
            int i;
            this.callableStatement = this.getConnection().prepareCall(proc);
            for (i = 0; i < args.length; ++i) {
                this.callableStatement.setObject(i + 1, args[i]);
            }
            for (i = 1; i <= outArgs.length; i += 2) {
                this.callableStatement.registerOutParameter((int)((Integer)outArgs[i]), (int)((Integer)outArgs[i + 1]));
            }
            this.callableStatement.execute();
            return this.callableStatement;
        }
        catch (SQLException e) {
            System.out.println(e.getMessage() + "==");
            return null;
        }
    }

    @Override
    @FuncVerification(version="1.1.0", status=VerifiedType.Unverified, date="2020/4/26 21:51")
    public int begin() {
        if (this.connection != null) {
            return 0;
        }
        try {
            this.getConnection();
            this.connection.setAutoCommit(false);
            return 1;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    @FuncVerification(version="1.1.0", status=VerifiedType.Unverified, date="2020/4/26 21:59")
    public int commitTransaction() {
        if (this.connection == null) {
            return 0;
        }
        try {
            this.getConnection();
            this.connection.commit();
            this.intBatchCount = 0;
            return 1;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    @FuncVerification(version="1.1.0", status=VerifiedType.Unverified, date="2020/4/26 21:57")
    public int rollback() {
        if (this.connection == null) {
            return 0;
        }
        try {
            this.getConnection();
            this.connection.rollback();
            this.intBatchCount = 0;
            return 1;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    @FuncVerification(version="1.1.0", status=VerifiedType.Unverified, date="2020/4/27 01:03")
    public int changeAutoCommit() {
        if (this.connection == null) {
            return 0;
        }
        try {
            this.connection.setAutoCommit(false);
            return 1;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/4/26 23:07")
    public int add(String sql) {
        if (this.statement == null) {
            try {
                this.statement = this.getConnection().createStatement();
                return this.add(sql);
            }
            catch (SQLException e) {
                e.printStackTrace();
                return -1;
            }
        }
        this.add(new String[0]);
        try {
            this.statement.addBatch(sql);
            ++this.intBatchCount;
            return 1;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    @FuncVerification(version="1.1.0", status=VerifiedType.Unverified, date="2020/4/26 22:04")
    public int add(String[] sql) {
        if (this.statement == null) {
            try {
                this.statement = this.getConnection().createStatement();
                return this.add(sql);
            }
            catch (SQLException e) {
                e.printStackTrace();
                return -1;
            }
        }
        int count = 0;
        try {
            for (String s : sql) {
                ++count;
                this.statement.addBatch(s);
            }
            this.intBatchCount += count;
            return count;
        }
        catch (SQLException e) {
            e.printStackTrace();
            if (count != 0) {
                this.intBatchCount += --count;
                return count;
            }
            return 0;
        }
    }

    @Override
    @FuncVerification(version="1.1.0", status=VerifiedType.Unverified, date="2020/4/26 22:04")
    public int addBatch(Object[] args) {
        if (this.preparedStatement == null) {
            return 0;
        }
        try {
            for (int i = 0; i < args.length; ++i) {
                this.preparedStatement.setObject(i + 1, args[i]);
            }
            this.preparedStatement.addBatch();
            ++this.intBatchCount;
            return 1;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    @FuncVerification(version="1.1.0", status=VerifiedType.Unverified, date="2020/4/26 23:19")
    public int executeBatch() {
        int count = 0;
        try {
            int[] tempCount;
            if (this.statement != null) {
                tempCount = this.statement.executeBatch();
                this.statement.clearBatch();
            } else if (this.preparedStatement != null) {
                tempCount = this.preparedStatement.executeBatch();
                this.preparedStatement.clearBatch();
            } else {
                return -1;
            }
            for (int i : tempCount) {
                count += i;
            }
            return count;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -2;
        }
    }

    @Override
    @FuncVerification(version="1.1.0", status=VerifiedType.Unverified, date="2020/4/26 23:19")
    public int executeBatch(int type) {
        int count = 0;
        try {
            int[] tempCount;
            switch (type) {
                case 1: {
                    tempCount = this.statement.executeBatch();
                    this.statement.clearBatch();
                    break;
                }
                case 2: {
                    tempCount = this.preparedStatement.executeBatch();
                    this.preparedStatement.clearBatch();
                    break;
                }
                default: {
                    return -1;
                }
            }
            for (int i : tempCount) {
                count += i;
            }
            return count;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -2;
        }
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/12 11:50")
    public void closePart() {
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
            if (this.callableStatement != null) {
                this.callableStatement.close();
            }
            if (this.preparedStatement != null) {
                this.preparedStatement.close();
            }
            if (this.statement != null) {
                this.statement.close();
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    @Override
    public void close() throws Exception {
        try {
            this.closePart();
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public JdbcImpl() {
    }

    public JdbcImpl(String path) {
        super.use(path);
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }

    @Override
    public PreparedStatement getPreparedStatement() {
        return this.preparedStatement;
    }

    @Override
    public CallableStatement getCallableStatement() {
        return this.callableStatement;
    }

    @Override
    public ResultSet getResultSet() {
        return this.resultSet;
    }
}

