/*
 * Decompiled with CFR 0.152.
 */
package com.kevinkda.core.util.util.date;

import com.kevinkda.core.util.annotation.enumeration.VerifiedType;
import com.kevinkda.core.util.annotation.func.FuncVerification;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Date;

public class DateTimeUtil {
    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 13:06")
    public static String formatStringByDateTime(Date date) {
        return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(date);
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/24 00:03")
    public static Date formatStringByDate(String date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date dateBack = null;
        try {
            dateBack = simpleDateFormat.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return dateBack;
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 13:06")
    public static Date stampToDate(String s) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long lt = new Long(s);
        return new Date(lt);
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 13:06")
    public static long currentToStart(Date startDate) {
        return Math.abs(DateTimeUtil.currentToEnd(startDate));
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 13:06")
    public static long currentToEnd(Date endDate) {
        String[] currentStr = new SimpleDateFormat("yyyy-MM-dd").format(new Date()).split("-");
        String[] endStr = new SimpleDateFormat("yyyy-MM-dd").format(endDate).split("-");
        Integer currentYear = Integer.parseInt(currentStr[0]);
        Integer currentMonth = Integer.parseInt(currentStr[1]);
        Integer currentDay = Integer.parseInt(currentStr[2]);
        int endYear = Integer.parseInt(endStr[0]);
        int endMonth = Integer.parseInt(endStr[1]);
        int endDay = Integer.parseInt(endStr[2]);
        LocalDate endLocalDate = LocalDate.of(endYear, endMonth, endDay);
        return LocalDate.now().until(endLocalDate, ChronoUnit.DAYS);
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 13:06")
    public static long startToEnd(Date startDate, Date endDate) {
        String[] startStr = new SimpleDateFormat("yyyy-MM-dd").format(startDate).split("-");
        String[] endStr = new SimpleDateFormat("yyyy-MM-dd").format(endDate).split("-");
        int startYear = Integer.parseInt(startStr[0]);
        int startMonth = Integer.parseInt(startStr[1]);
        int startDay = Integer.parseInt(startStr[2]);
        int endYear = Integer.parseInt(endStr[0]);
        int endMonth = Integer.parseInt(endStr[1]);
        int endDay = Integer.parseInt(endStr[2]);
        LocalDate endLocalDate = LocalDate.of(endYear, endMonth, endDay);
        LocalDate startLocalDate = LocalDate.of(startYear, startMonth, startDay);
        return startLocalDate.until(endLocalDate, ChronoUnit.DAYS);
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/28 23:22")
    public static long addMillisecond(Date date, long param) {
        return DateTimeUtil.addMillisecond(date.getTime(), param);
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/28 23:22")
    public static long addMillisecond(long date, long param) {
        return date + param;
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/28 23:28")
    public static Date addMillisecondOfDate(Date date, long param) {
        return new Date(date.getTime() + param);
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/28 23:28")
    public static Date addMillisecondOfDate(long date, long param) {
        return new Date(DateTimeUtil.addMillisecond(date, param));
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/28 23:22")
    public static long addSecond(Date date, long param) {
        return DateTimeUtil.addSecond(date.getTime(), param);
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/28 23:22")
    public static long addSecond(long date, long param) {
        return DateTimeUtil.addMillisecond(date, param * 1000L);
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/28 23:28")
    public static Date addSecondOfDate(Date date, long param) {
        return new Date(DateTimeUtil.addSecond(date.getTime(), param));
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/28 23:28")
    public static Date addSecondOfDate(long date, long param) {
        return new Date(DateTimeUtil.addSecond(date, param));
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/28 23:22")
    public static long addMinute(Date date, double param) {
        return DateTimeUtil.addMinute(date.getTime(), param);
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/28 23:22")
    public static long addMinute(long date, double param) {
        return DateTimeUtil.addSecond(date, (long)(param * 60.0));
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/28 23:28")
    public static Date addMinuteOfDate(Date date, double param) {
        return new Date(DateTimeUtil.addMinute(date.getTime(), param));
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/28 23:28")
    public static Date addMinuteOfDate(long date, double param) {
        return new Date(DateTimeUtil.addMinute(date, param));
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/28 23:22")
    public static long addHour(Date date, double param) {
        return DateTimeUtil.addHour(date.getTime(), param);
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/28 23:22")
    public static long addHour(long date, double param) {
        return DateTimeUtil.addMinute(date, param * 60.0);
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/28 23:28")
    public static Date addHourOfDate(Date date, double param) {
        return new Date(DateTimeUtil.addHour(date.getTime(), param));
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/28 23:28")
    public static Date addHourOfDate(long date, double param) {
        return new Date(DateTimeUtil.addHour(date, param));
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/28 23:22")
    public static long addDay(Date date, double param) {
        return DateTimeUtil.addDay(date.getTime(), param);
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/28 23:22")
    public static long addDay(long date, double param) {
        return DateTimeUtil.addHour(date, param * 24.0);
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/28 23:28")
    public static Date addDayOfDate(Date date, double param) {
        return new Date(DateTimeUtil.addDay(date.getTime(), param));
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/28 23:28")
    public static Date addDayOfDate(long date, double param) {
        return new Date(DateTimeUtil.addDay(date, param));
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/28 23:22")
    public static long addMonth(Date date, double param) {
        return DateTimeUtil.addMonth(date.getTime(), param);
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/28 23:22")
    public static long addMonth(long date, double param) {
        return DateTimeUtil.addDay(date, param * 30.0);
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/28 23:28")
    public static Date addMonthOfDate(Date date, double param) {
        return new Date(DateTimeUtil.addMonth(date.getTime(), param));
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/28 23:28")
    public static Date addMonthOfDate(long date, double param) {
        return new Date(DateTimeUtil.addMonth(date, param));
    }
}

