/*
 * Decompiled with CFR 0.152.
 */
package com.kevinkda.core.util.util.bean.impl;

import com.kevinkda.core.util.annotation.enumeration.VerifiedType;
import com.kevinkda.core.util.annotation.func.FuncVerification;
import com.kevinkda.core.util.util.bean.BeanCommon;
import com.kevinkda.core.util.util.string.impl.StringHelper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BeanCommonImpl
implements BeanCommon {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanCommonImpl.class);

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/5 15:04")
    public <T> T toBean(Map<String, Object> map, Class<T> clazz) {
        try {
            T bean = clazz.newInstance();
            BeanUtils.populate(bean, map);
            return bean;
        }
        catch (Exception e) {
            LOGGER.debug(e.getLocalizedMessage());
            LOGGER.debug(e.getMessage());
            LOGGER.debug(String.valueOf(e.getCause()));
            throw new RuntimeException(e);
        }
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 13:52")
    public void setValue(Object o, String value) {
        String[] results = value.split("\\|");
        for (int i = 0; i < results.length; ++i) {
            String[] attval = results[i].split(":");
            Object currentObject = o;
            try {
                if (attval[0].contains("\\.")) {
                    String[] temp = attval[0].split("\\.");
                    for (int j = 0; j < temp.length - 1; ++j) {
                        Method getMethod = o.getClass().getDeclaredMethod("get" + StringHelper.initialUppercase(temp[j]), new Class[0]);
                        Object tempObject = getMethod.invoke(currentObject, new Object[0]);
                        if (tempObject == null) {
                            Field field = currentObject.getClass().getDeclaredField(temp[j]);
                            Method method = currentObject.getClass().getDeclaredMethod("set" + StringHelper.initialUppercase(temp[j], field.getType()), new Class[0]);
                            Object newObject = field.getType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            method.invoke(currentObject, newObject);
                            currentObject = newObject;
                            continue;
                        }
                        currentObject = tempObject;
                    }
                    Field field = currentObject.getClass().getDeclaredField(temp[temp.length - 1]);
                    Method setMethod = currentObject.getClass().getDeclaredMethod("set" + StringHelper.initialUppercase(temp[temp.length - 1], field.getType()), new Class[0]);
                    Object convertValue = this.convertAttributeValue(field.getType().getName(), attval[1]);
                    Object object = setMethod.invoke(currentObject, convertValue);
                    continue;
                }
                Field field = o.getClass().getDeclaredField(attval[0]);
                Method setMethod = o.getClass().getDeclaredMethod("set" + StringHelper.initialUppercase(attval[0], field.getType()), new Class[0]);
                Object convertValue = this.convertAttributeValue(field.getType().getName(), attval[1]);
                Object object = setMethod.invoke(o, convertValue);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 13:53")
    private Object convertAttributeValue(String type, String value) {
        if ("long".equals(type) || "java.lang.Long".equals(type)) {
            return Long.parseLong(value);
        }
        if ("int".equals(type) || "java.lang.int".equals(type)) {
            return Integer.parseInt(value);
        }
        if ("double".equals(type) || "java.lang.double".equals(type)) {
            return Double.parseDouble(value);
        }
        if ("java.lang.Date".equals(type)) {
            SimpleDateFormat simpleDateFormat = null;
            if (value.matches("\\d{4}-\\d{2}-\\d{2}")) {
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            } else if (value.matches("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}")) {
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            } else {
                return new Date();
            }
            try {
                return simpleDateFormat.parse(value);
            }
            catch (ParseException e) {
                return new Date();
            }
        }
        return value;
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/10/15 15:04")
    public <T> Map<?, ?> convert2Map(T t) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Method[] methods = t.getClass().getMethods();
        try {
            for (Method method : methods) {
                String methodName;
                Class<?>[] paramClass = method.getParameterTypes();
                if (paramClass.length > 0 || !(methodName = method.getName()).startsWith("get")) continue;
                Object value = method.invoke(t, new Object[0]);
                result.put(methodName, value);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return result;
    }
}

