/*
 * Decompiled with CFR 0.152.
 */
package com.kevinkda.core.util.util.algorithm.tree;

import com.kevinkda.core.util.annotation.enumeration.VerifiedType;
import com.kevinkda.core.util.annotation.func.FuncVerification;

public class RebBlackTree<T>
implements Comparable<T> {
    private Node root;
    private int intCount;
    private Object[] returnData;
    private int foot = 0;

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/10/14 12:49")
    public void add(Comparable<T> data) {
        if (data == null) {
            throw new NullPointerException("\u4fdd\u5b58\u6570\u636e\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        Node newnode = new Node(data);
        if (this.root == null) {
            this.root = newnode;
        } else {
            this.root.addNode(newnode);
        }
        ++this.intCount;
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/10/14 12:52")
    public Object[] toArray() {
        if (this.intCount == 0) {
            return null;
        }
        this.returnData = new Object[this.intCount];
        this.foot = 0;
        this.root.toArrayNode();
        return this.returnData;
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/10/14 12:52")
    public void remove(Comparable<T> data) {
        if (this.root == null) {
            return;
        }
        if (this.root.data.compareTo(data) == 0) {
            Node moveNode = this.root.right;
            while (moveNode.left != null) {
                moveNode = moveNode.left;
            }
            moveNode.left = this.root.left;
            moveNode.right = this.root.right;
            moveNode.parent.left = null;
            this.root = moveNode;
        } else {
            Node removeNode = this.root.getRemoveNode(data);
            if (removeNode != null) {
                if (removeNode.left == null && removeNode.right == null) {
                    removeNode.parent.left = null;
                    removeNode.parent.right = null;
                    removeNode.parent = null;
                } else if (removeNode.left != null && removeNode.right == null) {
                    removeNode.parent.left = removeNode.left;
                    removeNode.left.parent = removeNode.parent;
                } else if (removeNode.left == null && removeNode.right != null) {
                    removeNode.parent.left = removeNode.right;
                    removeNode.right.parent = removeNode.parent;
                } else {
                    Node moveNode = removeNode.right;
                    while (moveNode.left != null) {
                        moveNode = moveNode.left;
                    }
                    removeNode.parent.left = moveNode;
                    moveNode.parent.left = null;
                    moveNode.parent = removeNode.parent;
                    removeNode.right = removeNode.right;
                    removeNode.left = removeNode.left;
                }
            }
        }
        --this.intCount;
    }

    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/10/14 12:53")
    private boolean contains(Comparable<T> data) {
        if (this.intCount == 0) {
            return false;
        }
        return this.root.containsNode(data);
    }

    @Override
    @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 12:57")
    public int compareTo(T o) {
        return 0;
    }

    private class Node {
        private Comparable<T> data;
        private Node parent;
        private Node left;
        private Node right;
        private Color flag;

        public Node(Comparable<T> data) {
            this.data = data;
        }

        @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 13:03")
        private void addNode(Node newNode) {
            if (newNode.data.compareTo(this.data) <= 0) {
                if (this.left == null) {
                    this.left = newNode;
                    newNode.parent = this;
                } else {
                    this.left.addNode(newNode);
                }
            } else if (this.right == null) {
                this.right = newNode;
                newNode.parent = this;
            } else {
                this.right.addNode(newNode);
            }
        }

        @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 13:03")
        public void toArrayNode() {
            if (this.left != null) {
                this.left.toArrayNode();
            }
            ((RebBlackTree)RebBlackTree.this).returnData[((RebBlackTree)RebBlackTree.this).foot++] = this.data;
            if (this.right != null) {
                this.right.toArrayNode();
            }
        }

        @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 13:03")
        public boolean containsNode(Comparable<T> data) {
            if (data.compareTo(this.data) == 0) {
                return true;
            }
            if (data.compareTo(this.data) < 0) {
                if (this.left != null) {
                    return this.left.containsNode(data);
                }
                return false;
            }
            if (this.right != null) {
                return this.right.containsNode(data);
            }
            return false;
        }

        @FuncVerification(version="1.0.0", status=VerifiedType.Unverified, date="2020/5/4 13:03")
        public Node getRemoveNode(Comparable<T> data) {
            if (data.compareTo(this.data) == 0) {
                return this;
            }
            if (data.compareTo(this.data) < 0) {
                if (this.left != null) {
                    return this.left.getRemoveNode(data);
                }
                return null;
            }
            if (this.right != null) {
                return this.right.getRemoveNode(data);
            }
            return null;
        }
    }

    private static enum Color {
        RED,
        BLACK;

    }
}

